/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.resources;

import org.kie.kogito.resources.ConditionHolder;
import org.kie.kogito.resources.TestResource;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.test.context.support.TestPropertySourceUtils;

public abstract class ConditionalSpringBootTestResource
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
ApplicationListener<ContextClosedEvent> {
    private final TestResource testResource;
    private final ConditionHolder condition;
    private boolean conditionalEnabled = false;

    public ConditionalSpringBootTestResource(TestResource testResource) {
        this(testResource, new ConditionHolder(testResource.getResourceName()));
    }

    public ConditionalSpringBootTestResource(TestResource testResource, ConditionHolder condition) {
        this.testResource = testResource;
        this.condition = condition;
    }

    public TestResource getTestResource() {
        return this.testResource;
    }

    public boolean isConditionalEnabled() {
        return this.conditionalEnabled;
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        if (this.condition.isEnabled()) {
            this.testResource.start();
            this.updateBeanFactory(applicationContext.getBeanFactory());
            this.updateContextProperty(applicationContext, this.getKogitoProperty(), this.getKogitoPropertyValue());
        }
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        if (this.condition.isEnabled()) {
            this.testResource.stop();
        }
    }

    protected abstract String getKogitoProperty();

    protected String getKogitoPropertyValue() {
        return "localhost:" + this.testResource.getMappedPort();
    }

    protected void enableConditional() {
        this.condition.enableConditional();
        this.conditionalEnabled = true;
    }

    protected void updateBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.registerSingleton(this.testResource.getResourceName() + "ShutDownHook", (Object)this);
    }

    protected void updateContextProperty(ConfigurableApplicationContext applicationContext, String key, String value) {
        TestPropertySourceUtils.addInlinedPropertiesToEnvironment((ConfigurableApplicationContext)applicationContext, (String[])new String[]{key + "=" + value});
    }
}

