/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers.quarkus;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kie.kogito.resources.ConditionalQuarkusTestResource;
import org.kie.kogito.testcontainers.KogitoKeycloakContainer;

public class KeycloakQuarkusTestResource
extends ConditionalQuarkusTestResource {
    public static final String KOGITO_KEYCLOAK_PROPERTY = "quarkus.oidc.auth-server-url";
    public static final String KOGITO_OIDC_TENANTS = "kogito.test.tenants";
    private List<String> tenants = Collections.emptyList();

    public KeycloakQuarkusTestResource() {
        super(new KogitoKeycloakContainer());
    }

    public void init(Map<String, String> initArgs) {
        if (initArgs.containsKey(KOGITO_OIDC_TENANTS)) {
            this.tenants = Arrays.stream(initArgs.getOrDefault(KOGITO_OIDC_TENANTS, "").split(",")).collect(Collectors.toList());
        }
    }

    @Override
    protected String getKogitoProperty() {
        return KOGITO_KEYCLOAK_PROPERTY;
    }

    @Override
    protected String getKogitoPropertyValue() {
        return String.format("http://localhost:%s/auth/realms/kogito", this.getTestResource().getMappedPort());
    }

    @Override
    public Map<String, String> start() {
        Map<String, String> start = super.start();
        if (start.isEmpty() || this.tenants.isEmpty()) {
            return start;
        }
        start = new HashMap<String, String>(start);
        String url = start.get(this.getKogitoProperty());
        start.putAll(this.tenants.stream().map(tenant -> String.format("quarkus.oidc.%s.auth-server-url", tenant)).collect(Collectors.toMap(Function.identity(), s -> url)));
        return start;
    }

    public static class Conditional
    extends KeycloakQuarkusTestResource {
        public Conditional() {
            this.enableConditional();
        }
    }
}

