/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.testcontainers.KogitoMongoDBContainer;
import org.mockito.Mockito;

class KogitoMongoDBContainerTest {
    private static final int MAPPED_PORT = 27020;
    private KogitoMongoDBContainer container;

    KogitoMongoDBContainerTest() {
    }

    @BeforeEach
    public void setup() {
        this.container = (KogitoMongoDBContainer)Mockito.spy((Object)new KogitoMongoDBContainer());
        ((KogitoMongoDBContainer)Mockito.doNothing().when((Object)this.container)).start();
    }

    @Test
    void shouldGetResourceName() {
        Assertions.assertEquals((Object)"mongodb", (Object)this.container.getResourceName());
    }

    @Test
    void shouldGetMapperPort() {
        ((KogitoMongoDBContainer)Mockito.doReturn((Object)27020).when((Object)this.container)).getMappedPort(27018);
        Assertions.assertEquals((int)27020, (int)this.container.getMappedPort());
    }

    @Test
    void shouldGetDockerImageName() {
        Assertions.assertEquals((Object)("library/" + System.getProperty("container.image.mongodb")), (Object)this.container.getDockerImageName());
    }
}

