/*
 * Copyright 2021 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kie.kogito.test.utils;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertTrue;
import static org.kie.kogito.test.utils.SocketUtils.PORT_RANGE_MAX;
import static org.kie.kogito.test.utils.SocketUtils.PORT_RANGE_MIN;

public class SocketUtilsTest {

    @Test
    public void findAvailablePortTest() {
        int availablePort = SocketUtils.findAvailablePort();
        assertTrue(availablePort <= PORT_RANGE_MAX);
        assertTrue(availablePort >= PORT_RANGE_MIN);
    }

}
