/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.testcontainers.KogitoKeycloakContainer;
import org.mockito.Mockito;

public class KeycloakContainerTest {
    private static final int MAPPED_PORT = 11112;
    private static final String IMAGE = "my-keycloak-image";
    private KogitoKeycloakContainer container;

    @BeforeEach
    public void setup() {
        System.setProperty("container.image.keycloak", IMAGE);
        this.container = (KogitoKeycloakContainer)Mockito.spy((Object)new KogitoKeycloakContainer());
        ((KogitoKeycloakContainer)Mockito.doNothing().when((Object)this.container)).start();
        ((KogitoKeycloakContainer)Mockito.doNothing().when((Object)this.container)).setDockerImageName(IMAGE);
    }

    @Test
    public void shouldAddDefaultSettings() {
        Assertions.assertTrue((boolean)this.container.getExposedPorts().contains(8080));
        Assertions.assertEquals((Object)"admin", this.container.getEnvMap().get("KEYCLOAK_USER"));
        Assertions.assertEquals((Object)"admin", this.container.getEnvMap().get("KEYCLOAK_PASSWORD"));
    }

    @Test
    public void shouldGetResourceName() {
        Assertions.assertEquals((Object)"keycloak", (Object)this.container.getResourceName());
    }

    @Test
    public void shouldGetMapperPort() {
        ((KogitoKeycloakContainer)Mockito.doReturn((Object)11112).when((Object)this.container)).getMappedPort(8080);
        Assertions.assertEquals((int)11112, (int)this.container.getMappedPort());
    }
}

