/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers.quarkus;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.testcontainers.quarkus.InfinispanQuarkusTestResource;
import org.mockito.Mockito;

public class InfinispanQuarkusTestResourceTest {
    private static final String IMAGE = "my-infinispan-image";
    private InfinispanQuarkusTestResource resource;

    @BeforeEach
    public void setup() {
        System.setProperty("container.image.infinispan", IMAGE);
    }

    @Test
    public void shouldGetProperty() {
        this.givenResource();
        Assertions.assertEquals((Object)"quarkus.infinispan-client.server-list", (Object)this.resource.getKogitoProperty());
    }

    @Test
    public void shouldConditionalBeDisabledByDefault() {
        this.givenResource();
        this.thenConditionalIsDisabled();
    }

    @Test
    public void shouldConditionalBeEnabled() {
        this.givenConditionalResource();
        this.thenConditionalIsEnabled();
    }

    private void givenResource() {
        this.resource = new InfinispanQuarkusTestResource();
    }

    private void givenConditionalResource() {
        this.resource = (InfinispanQuarkusTestResource)Mockito.spy((Object)new InfinispanQuarkusTestResource.Conditional());
    }

    private void thenConditionalIsEnabled() {
        Assertions.assertTrue((boolean)this.resource.isConditionalEnabled());
    }

    private void thenConditionalIsDisabled() {
        Assertions.assertFalse((boolean)this.resource.isConditionalEnabled());
    }
}

