/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.resources;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Resource;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.resources.ConditionHolder;
import org.kie.kogito.resources.TestResource;

public abstract class ConditionalQuarkusTestResource
implements QuarkusTestResourceLifecycleManager {
    private final TestResource testResource;
    private final ConditionHolder condition;
    private boolean conditionalEnabled = false;

    public ConditionalQuarkusTestResource(TestResource testResource) {
        this(testResource, new ConditionHolder(testResource.getResourceName()));
    }

    public ConditionalQuarkusTestResource(TestResource testResource, ConditionHolder condition) {
        this.testResource = testResource;
        this.condition = condition;
    }

    public TestResource getTestResource() {
        return this.testResource;
    }

    public boolean isConditionalEnabled() {
        return this.conditionalEnabled;
    }

    public Map<String, String> start() {
        if (this.condition.isEnabled()) {
            this.testResource.start();
            return Collections.singletonMap(this.getKogitoProperty(), this.getKogitoPropertyValue());
        }
        return Collections.emptyMap();
    }

    public void stop() {
        if (this.condition.isEnabled()) {
            this.testResource.stop();
        }
    }

    public void inject(Object testInstance) {
        for (Class<?> c = testInstance.getClass(); c != Object.class; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                ConfigProperty configProperty = f.getAnnotation(ConfigProperty.class);
                if (configProperty != null && this.getKogitoProperty().equals(configProperty.name())) {
                    this.setFieldValue(f, testInstance, this.getKogitoPropertyValue());
                    continue;
                }
                if (!f.isAnnotationPresent(Resource.class) || !f.getType().isInstance(this)) continue;
                this.setFieldValue(f, testInstance, this);
            }
        }
    }

    protected abstract String getKogitoProperty();

    protected String getKogitoPropertyValue() {
        return "localhost:" + this.testResource.getMappedPort();
    }

    protected void enableConditional() {
        this.condition.enableConditional();
        this.conditionalEnabled = true;
    }

    private void setFieldValue(Field f, Object testInstance, Object value) {
        try {
            f.setAccessible(true);
            f.set(testInstance, value);
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

