/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers;

import java.util.function.Consumer;
import org.kie.kogito.resources.TestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class KogitoInfinispanContainer
extends GenericContainer<KogitoInfinispanContainer>
implements TestResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(KogitoInfinispanContainer.class);
    public static final String NAME = "infinispan";
    public static final int PORT = 11222;
    public static final String INFINISPAN_PROPERTY = "container.image.infinispan";
    public static final String CONF_PATH = "/opt/infinispan/server/conf/";

    public KogitoInfinispanContainer() {
        this.addExposedPort(11222);
        this.withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER));
        this.waitingFor((WaitStrategy)Wait.forHttp((String)"/"));
        this.setDockerImageName(System.getProperty(INFINISPAN_PROPERTY));
        this.withClasspathResourceMapping("testcontainers/infinispan/infinispan-local.xml", "/opt/infinispan/server/conf/infinispan-local.xml", BindMode.READ_ONLY);
        this.withClasspathResourceMapping("testcontainers/infinispan/users.properties", "/opt/infinispan/server/conf/users.properties", BindMode.READ_ONLY);
        this.withClasspathResourceMapping("testcontainers/infinispan/groups.properties", "/opt/infinispan/server/conf/groups.properties", BindMode.READ_ONLY);
        this.setCommand("/opt/infinispan/bin/server.sh -c infinispan-local.xml");
    }

    @Override
    public int getMappedPort() {
        return this.getMappedPort(11222);
    }

    @Override
    public String getResourceName() {
        return NAME;
    }
}

