/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.testcontainers.KogitoInfinispanContainer;
import org.mockito.Mockito;

public class InfinispanContainerTest {
    private static final int MAPPED_PORT = 11111;
    private static final String IMAGE = "my-infinispan-image";
    private KogitoInfinispanContainer container;

    @BeforeEach
    public void setup() {
        System.setProperty("container.image.infinispan", IMAGE);
        this.container = (KogitoInfinispanContainer)Mockito.spy((Object)new KogitoInfinispanContainer());
        ((KogitoInfinispanContainer)Mockito.doNothing().when((Object)this.container)).start();
        ((KogitoInfinispanContainer)Mockito.doNothing().when((Object)this.container)).setDockerImageName(IMAGE);
    }

    @Test
    public void shouldAddDefaultSettings() {
        Assertions.assertThat((List)this.container.getExposedPorts()).contains((Object[])new Integer[]{11222});
    }

    @Test
    public void shouldGetResourceName() {
        Assertions.assertThat((String)this.container.getResourceName()).isEqualTo("infinispan");
    }

    @Test
    public void shouldGetMapperPort() {
        ((KogitoInfinispanContainer)Mockito.doReturn((Object)11111).when((Object)this.container)).getMappedPort(11222);
        Assertions.assertThat((int)this.container.getMappedPort()).isEqualTo(11111);
    }
}

