/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.testcontainers.KogitoKeycloakContainer;
import org.mockito.Mockito;

public class KeycloakContainerTest {
    private static final int MAPPED_PORT = 11112;
    private static final String IMAGE = "my-keycloak-image";
    private KogitoKeycloakContainer container;

    @BeforeEach
    public void setup() {
        System.setProperty("container.image.keycloak", IMAGE);
        this.container = (KogitoKeycloakContainer)Mockito.spy((Object)new KogitoKeycloakContainer());
        ((KogitoKeycloakContainer)Mockito.doNothing().when((Object)this.container)).start();
        ((KogitoKeycloakContainer)Mockito.doNothing().when((Object)this.container)).setDockerImageName(IMAGE);
    }

    @Test
    public void shouldAddDefaultSettings() {
        Assertions.assertThat((List)this.container.getExposedPorts()).contains((Object[])new Integer[]{8080});
        ((MapAssert)Assertions.assertThat((Map)this.container.getEnvMap()).containsEntry((Object)"KEYCLOAK_USER", (Object)"admin")).containsEntry((Object)"KEYCLOAK_PASSWORD", (Object)"admin");
    }

    @Test
    public void shouldGetResourceName() {
        Assertions.assertThat((String)this.container.getResourceName()).isEqualTo("keycloak");
    }

    @Test
    public void shouldGetMapperPort() {
        ((KogitoKeycloakContainer)Mockito.doReturn((Object)11112).when((Object)this.container)).getMappedPort(8080);
        Assertions.assertThat((int)this.container.getMappedPort()).isEqualTo(11112);
    }
}

