/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers.springboot;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.testcontainers.springboot.KeycloakSpringBootTestResource;
import org.mockito.Mockito;

public class KeycloakSpringBootTestResourceTest {
    private static final String IMAGE = "my-keycloak-image";
    private KeycloakSpringBootTestResource resource;

    @BeforeEach
    public void setup() {
        System.setProperty("container.image.keycloak", IMAGE);
    }

    @Test
    public void shouldGetProperty() {
        this.givenResource();
        Assertions.assertEquals((Object)"keycloak.auth-server-url", (Object)this.resource.getKogitoProperty());
    }

    @Test
    public void shouldConditionalBeDisabledByDefault() {
        this.givenResource();
        this.thenConditionalIsDisabled();
    }

    @Test
    public void shouldConditionalBeEnabled() {
        this.givenConditionalResource();
        this.thenConditionalIsEnabled();
    }

    private void givenResource() {
        this.resource = new KeycloakSpringBootTestResource();
    }

    private void givenConditionalResource() {
        this.resource = (KeycloakSpringBootTestResource)Mockito.spy((Object)new KeycloakSpringBootTestResource.Conditional());
    }

    private void thenConditionalIsEnabled() {
        Assertions.assertTrue((boolean)this.resource.isConditionalEnabled());
    }

    private void thenConditionalIsDisabled() {
        Assertions.assertFalse((boolean)this.resource.isConditionalEnabled());
    }
}

