/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers.springboot;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.testcontainers.KogitoMongoDBContainer;
import org.kie.kogito.testcontainers.springboot.MongoDBSpringBootTestResource;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class MongoDBSpringBootTestResourceTest {
    @Mock
    private KogitoMongoDBContainer container;
    private MongoDBSpringBootTestResource resource;

    MongoDBSpringBootTestResourceTest() {
    }

    @Test
    void shouldGetProperty() {
        this.givenResource();
        Assertions.assertEquals((Object)"spring.data.mongodb.uri", (Object)this.resource.getKogitoProperty());
        Assertions.assertThrows(IllegalStateException.class, () -> this.resource.getKogitoPropertyValue());
    }

    @Test
    void shouldConditionalBeDisabledByDefault() {
        this.givenResource();
        this.thenConditionalIsDisabled();
    }

    @Test
    void shouldConditionalBeEnabled() {
        this.givenConditionalResource();
        this.thenConditionalIsEnabled();
    }

    private void givenConditionalResource() {
        this.resource = (MongoDBSpringBootTestResource)Mockito.spy((Object)new MongoDBSpringBootTestResource.Conditional());
    }

    private void givenResource() {
        this.resource = (MongoDBSpringBootTestResource)Mockito.spy((Object)new MongoDBSpringBootTestResource());
    }

    private void thenConditionalIsEnabled() {
        Assertions.assertTrue((boolean)this.resource.isConditionalEnabled());
    }

    private void thenConditionalIsDisabled() {
        Assertions.assertFalse((boolean)this.resource.isConditionalEnabled());
    }
}

