/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.testcontainers.KogitoPostgreSqlContainer;
import org.mockito.Mockito;
import org.testcontainers.containers.PostgreSQLContainer;

public class KogitoPostgreSqlContainerTest {
    private static final int MAPPED_PORT = 5432;
    private static final String IMAGE = "postgres";
    private KogitoPostgreSqlContainer container;

    @BeforeEach
    public void setup() {
        System.setProperty("container.image.postgresql", IMAGE);
        this.container = (KogitoPostgreSqlContainer)Mockito.spy((Object)new KogitoPostgreSqlContainer());
        ((KogitoPostgreSqlContainer)Mockito.doNothing().when((Object)this.container)).start();
        ((KogitoPostgreSqlContainer)Mockito.doNothing().when((Object)this.container)).setDockerImageName(IMAGE);
    }

    @Test
    public void shouldAddDefaultSettings() {
        Assertions.assertTrue((boolean)this.container.getExposedPorts().contains(PostgreSQLContainer.POSTGRESQL_PORT));
    }

    @Test
    public void shouldGetResourceName() {
        Assertions.assertEquals((Object)"postgresql", (Object)this.container.getResourceName());
    }

    @Test
    public void shouldGetMapperPort() {
        ((KogitoPostgreSqlContainer)Mockito.doReturn((Object)5432).when((Object)this.container)).getMappedPort(PostgreSQLContainer.POSTGRESQL_PORT.intValue());
        Assertions.assertEquals((int)5432, (int)this.container.getMappedPort());
    }
}

