/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers;

import java.text.MessageFormat;
import java.util.function.Consumer;
import org.kie.kogito.test.resources.TestResource;
import org.kie.kogito.testcontainers.Constants;
import org.kie.kogito.testcontainers.KogitoGenericContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.Slf4jLogConsumer;

public class KogitoPostgreSqlContainer
extends PostgreSQLContainer<KogitoPostgreSqlContainer>
implements TestResource {
    public static final String NAME = "postgres";
    public static final String POSTGRESQL_CONNECTION_URI = "kogito.persistence.postgresql.connection.uri";
    private static final Logger LOGGER = LoggerFactory.getLogger(KogitoPostgreSqlContainer.class);

    public KogitoPostgreSqlContainer() {
        super(KogitoGenericContainer.getImageName(NAME));
        this.withLogConsumer(this.getLogger());
        this.withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER));
        this.withStartupTimeout(Constants.CONTAINER_START_TIMEOUT);
    }

    private Consumer<OutputFrame> getLogger() {
        return f -> System.out.print(f.getUtf8String());
    }

    @Override
    public void start() {
        super.start();
        LOGGER.info("PostgreSql server: {}", (Object)(this.getContainerIpAddress() + ":" + this.getMappedPort(POSTGRESQL_PORT)));
    }

    @Override
    public int getMappedPort() {
        return this.getMappedPort(POSTGRESQL_PORT);
    }

    @Override
    public String getResourceName() {
        return "postgresql";
    }

    public String getReactiveUrl() {
        String connectionTemplate = "postgresql://{0}:{1}@{2}:{3}/{4}?search_path={5}";
        String user = this.getUsername();
        String server = this.getHost();
        String secret = this.getPassword();
        String port = String.valueOf(this.getMappedPort());
        String database = this.getDatabaseName();
        String schema = "public";
        return MessageFormat.format("postgresql://{0}:{1}@{2}:{3}/{4}?search_path={5}", user, secret, server, port, database, "public");
    }
}

