/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.testcontainers.KogitoKafkaContainer;
import org.mockito.Mockito;

public class KogitoKafkaContainerTest {
    private static final int MAPPED_PORT = 11113;
    private static final String IMAGE = "vectorized/redpanda:latest";
    private KogitoKafkaContainer container;

    @BeforeEach
    public void setup() {
        System.setProperty("container.image.kafka", IMAGE);
        this.container = (KogitoKafkaContainer)Mockito.spy((Object)new KogitoKafkaContainer());
        ((KogitoKafkaContainer)Mockito.doNothing().when((Object)this.container)).start();
        ((KogitoKafkaContainer)Mockito.doNothing().when((Object)this.container)).setDockerImageName(IMAGE);
    }

    @Test
    public void shouldGetResourceName() {
        Assertions.assertThat((String)this.container.getResourceName()).isEqualTo("kafka");
    }

    @Test
    public void shouldGetMapperPort() {
        ((KogitoKafkaContainer)Mockito.doReturn((Object)11113).when((Object)this.container)).getMappedPort(9092);
        Assertions.assertThat((int)this.container.getMappedPort()).isEqualTo(11113);
    }
}

