/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.test.utils;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.testcontainers.shaded.org.awaitility.Awaitility;

public class ProcessInstancesRESTTestUtils {
    private ProcessInstancesRESTTestUtils() {
    }

    public static String newProcessInstanceAndGetId(String processUrl, String processInput) {
        return (String)ProcessInstancesRESTTestUtils.newProcessInstance(processUrl, processInput).get("id");
    }

    public static JsonPath newProcessInstance(String processUrl, String processInput) {
        JsonPath result = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(processInput).post(processUrl, new Object[0])).then()).statusCode(201)).extract().jsonPath();
        String processInstanceId = (String)result.get("id");
        Assertions.assertThat((String)processInstanceId).isNotBlank();
        return result;
    }

    public static JsonPath newProcessInstance(String processUrl, String processInput, Map<String, ?> headers) {
        JsonPath result = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).headers(headers).body(processInput).post(processUrl, new Object[0])).then()).statusCode(201)).extract().jsonPath();
        String processInstanceId = (String)result.get("id");
        Assertions.assertThat((String)processInstanceId).isNotBlank();
        return result;
    }

    public static void assertProcessInstanceExists(String getProcessByIdQuery, String processInstanceId) {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).when().get(getProcessByIdQuery, new Object[]{processInstanceId})).then()).statusCode(200);
    }

    public static String getProcessInstance(String processUrl) {
        return (String)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).when().get(processUrl, new Object[0])).then()).statusCode(200)).extract().path("[0].id", new String[0]);
    }

    public static void assertProcessInstanceNotExists(String getProcessByIdQuery, String processInstanceId) {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).when().get(getProcessByIdQuery, new Object[]{processInstanceId})).then()).statusCode(404);
    }

    public static void assertProcessInstanceHasFinished(String getProcessByIdQuery, String processInstanceId, long atLeastTimeoutInSeconds, long atMostTimeoutInSeconds) {
        Awaitility.await().atLeast(atLeastTimeoutInSeconds, TimeUnit.SECONDS).atMost(atMostTimeoutInSeconds, TimeUnit.SECONDS).with().pollInterval(1L, TimeUnit.SECONDS).untilAsserted(() -> ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).get(getProcessByIdQuery, new Object[]{processInstanceId})).then()).statusCode(404));
    }
}

