/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.test.utils;

import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.kie.kogito.test.utils.CustomSVGDiffer;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonFormatter;
import org.xmlunit.diff.DefaultComparisonFormatter;
import org.xmlunit.diff.Diff;
import org.xmlunit.diff.Difference;

public final class CustomSVGMatcher
extends BaseMatcher<Object> {
    private static final ComparisonFormatter FORMATTER = new DefaultComparisonFormatter();
    private CustomSVGDiffer diffBuilder;
    private Diff diffResult;

    CustomSVGMatcher(CustomSVGDiffer diffBuilder) {
        this.diffBuilder = diffBuilder;
    }

    public static CustomSVGMatcher isSimilarTo(String content) {
        return new CustomSVGMatcher(new CustomSVGDiffer(content));
    }

    public boolean matches(Object item) {
        this.diffResult = this.diffBuilder.withTest(item);
        return !this.diffResult.hasDifferences();
    }

    public void describeTo(Description description) {
        if (this.diffResult == null || !this.diffResult.hasDifferences()) {
            description.appendText(" is similar to the control document");
        } else {
            Comparison difference = ((Difference)this.diffResult.getDifferences().iterator().next()).getComparison();
            String reason = this.createReasonPrefix(this.diffResult.getControlSource().getSystemId(), difference);
            String testString = FORMATTER.getDetails(difference.getControlDetails(), difference.getType(), true);
            description.appendText(String.format("%s:%n%s", reason, testString));
        }
    }

    private String createReasonPrefix(String systemId, Comparison difference) {
        String description = FORMATTER.getDescription(difference);
        String reason = systemId == null ? description : String.format("In Source '%s' %s", systemId, description);
        return reason;
    }
}

