/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers.quarkus;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.testcontainers.quarkus.KeycloakQuarkusTestResource;
import org.mockito.Mockito;

public class KeycloakQuarkusTestResourceTest {
    private static final String IMAGE = "my-keycloak-image";
    private KeycloakQuarkusTestResource resource;

    @BeforeEach
    public void setup() {
        System.setProperty("container.image.keycloak", IMAGE);
    }

    @Test
    public void shouldGetProperty() {
        this.givenResource();
        Assertions.assertEquals((Object)"quarkus.oidc.auth-server-url", (Object)this.resource.getKogitoProperty());
    }

    @Test
    public void shouldConditionalBeDisabledByDefault() {
        this.givenResource();
        this.thenConditionalIsDisabled();
    }

    @Test
    public void shouldConditionalBeEnabled() {
        this.givenConditionalResource();
        this.thenConditionalIsEnabled();
    }

    private void givenConditionalResource() {
        this.resource = (KeycloakQuarkusTestResource)Mockito.spy((Object)new KeycloakQuarkusTestResource.Conditional());
    }

    private void givenResource() {
        this.resource = (KeycloakQuarkusTestResource)Mockito.spy((Object)new KeycloakQuarkusTestResource());
    }

    private void thenConditionalIsEnabled() {
        Assertions.assertTrue((boolean)this.resource.isConditionalEnabled());
    }

    private void thenConditionalIsDisabled() {
        Assertions.assertFalse((boolean)this.resource.isConditionalEnabled());
    }
}

