/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers;

import java.time.Duration;
import java.util.function.Consumer;
import org.kie.kogito.resources.TestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;

public class KogitoRedisSearchContainer
extends GenericContainer<KogitoRedisSearchContainer>
implements TestResource {
    public static final String NAME = "redis";
    public static final String REDIS_PROPERTY = "container.image.redis";
    public static final int PORT = 6379;
    private static final Logger LOGGER = LoggerFactory.getLogger(KogitoRedisSearchContainer.class);

    public KogitoRedisSearchContainer() {
        this.addExposedPort(6379);
        this.withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER));
        this.waitingFor(Wait.forLogMessage((String)".*Ready to accept connections.*\\s", (int)1).withStartupTimeout(Duration.ofMinutes(5L)));
        this.setDockerImageName(System.getProperty(REDIS_PROPERTY));
    }

    @Override
    public int getMappedPort() {
        return this.getMappedPort(6379);
    }

    @Override
    public String getResourceName() {
        return NAME;
    }
}

