/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.resources;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.resources.ConditionHolder;
import org.kie.kogito.resources.ConditionalSpringBootTestResource;
import org.kie.kogito.resources.TestResource;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextClosedEvent;

@ExtendWith(value={MockitoExtension.class})
public class ConditionalSpringBootTestResourceTest {
    private static final int MAPPED_PORT = 8800;
    private static final String RESOURCE_NAME = "my-resource";
    private static final String KOGITO_PROPERTY = "my-kogito-property";
    private static final String KOGITO_PROPERTY_VALUE = "localhost:8800";
    @Mock
    private TestResource resource;
    @Mock
    private ConditionHolder conditional;
    @Mock
    private ConfigurableListableBeanFactory beanFactory;
    private ConditionalSpringBootTestResource instance;
    private Map<String, String> actualOutput;

    @BeforeEach
    public void setup() {
        this.actualOutput = new HashMap<String, String>();
        this.instance = new ConditionalSpringBootTestResource(this.resource, this.conditional){

            protected Map<String, String> getProperties() {
                return Collections.singletonMap(ConditionalSpringBootTestResourceTest.KOGITO_PROPERTY, ConditionalSpringBootTestResourceTest.KOGITO_PROPERTY_VALUE);
            }

            protected void updateContextProperty(ConfigurableApplicationContext applicationContext, String[] props) {
                Arrays.stream(props).forEach(prop -> {
                    String[] split = prop.split("=");
                    ConditionalSpringBootTestResourceTest.this.actualOutput.put(split[0], split[1]);
                });
            }
        };
        Mockito.lenient().when((Object)this.resource.getResourceName()).thenReturn((Object)RESOURCE_NAME);
        Mockito.lenient().when((Object)this.resource.getMappedPort()).thenReturn((Object)8800);
    }

    @Test
    public void shouldReturnResource() {
        Assertions.assertEquals((Object)this.resource, (Object)this.instance.getTestResource());
    }

    @Test
    public void shouldInvokeConditional() {
        this.instance.enableConditional();
        ((ConditionHolder)Mockito.verify((Object)this.conditional)).enableConditional();
    }

    @Test
    public void shouldStartIfConditionalIsEnabled() {
        this.givenConditionalEnabled();
        this.whenStartInstance();
        this.thenResourceIsStarted();
        this.thenConfigMapIsUpdated();
        this.thenShutdownHookIsRegistered();
    }

    @Test
    public void shouldNotStartIfConditionalIsDisabled() {
        this.givenConditionalDisabled();
        this.whenStartInstance();
        this.thenResourceIsNotUsed();
    }

    @Test
    public void shouldStopIfConditionalIsEnabled() {
        this.givenConditionalEnabled();
        this.whenStopInstance();
        this.thenResourceIsStopped();
    }

    @Test
    public void shouldNotStopIfConditionalIsDisabled() {
        this.givenConditionalDisabled();
        this.whenStopInstance();
        this.thenResourceIsNotUsed();
    }

    private void givenConditionalEnabled() {
        Mockito.when((Object)this.conditional.isEnabled()).thenReturn((Object)true);
    }

    private void givenConditionalDisabled() {
        Mockito.when((Object)this.conditional.isEnabled()).thenReturn((Object)false);
    }

    private void whenStartInstance() {
        ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)Mockito.mock(ConfigurableApplicationContext.class);
        Mockito.lenient().when((Object)applicationContext.getBeanFactory()).thenReturn((Object)this.beanFactory);
        this.instance.initialize(applicationContext);
    }

    private void whenStopInstance() {
        this.instance.onApplicationEvent((ContextClosedEvent)Mockito.mock(ContextClosedEvent.class));
    }

    private void thenResourceIsStarted() {
        ((TestResource)Mockito.verify((Object)this.resource)).start();
    }

    private void thenResourceIsStopped() {
        ((TestResource)Mockito.verify((Object)this.resource)).stop();
    }

    private void thenResourceIsNotUsed() {
        Mockito.verifyNoInteractions((Object[])new Object[]{this.resource});
    }

    private void thenConfigMapIsUpdated() {
        String actual = this.actualOutput.get(KOGITO_PROPERTY);
        Assertions.assertEquals((Object)KOGITO_PROPERTY_VALUE, (Object)actual);
    }

    private void thenShutdownHookIsRegistered() {
        ((ConfigurableListableBeanFactory)Mockito.verify((Object)this.beanFactory)).registerSingleton("my-resourceShutDownHook", (Object)this.instance);
    }
}

