/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers.springboot;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.testcontainers.KogitoMongoDBContainer;
import org.kie.kogito.testcontainers.springboot.MongoDBSpringBootTestResource;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class MongoDBSpringBootTestResourceTest {
    @Mock
    private KogitoMongoDBContainer container;
    private MongoDBSpringBootTestResource resource;

    MongoDBSpringBootTestResourceTest() {
    }

    @Test
    void shouldGetProperty() {
        this.givenResource();
        Assertions.assertThrows(IllegalStateException.class, () -> this.resource.getProperties().get("spring.data.mongodb.uri"));
    }

    @Test
    void shouldConditionalBeDisabledByDefault() {
        this.givenResource();
        this.thenConditionalIsDisabled();
    }

    @Test
    void shouldConditionalBeEnabled() {
        this.givenConditionalResource();
        this.thenConditionalIsEnabled();
    }

    @Test
    void shouldGetDockerImageName() {
        this.givenResource();
        Assertions.assertEquals((Object)("library/" + System.getProperty("container.image.mongodb")), (Object)((KogitoMongoDBContainer)this.resource.getTestResource()).getDockerImageName());
    }

    private void givenConditionalResource() {
        this.resource = (MongoDBSpringBootTestResource)Mockito.spy((Object)new MongoDBSpringBootTestResource.Conditional());
    }

    private void givenResource() {
        this.resource = (MongoDBSpringBootTestResource)Mockito.spy((Object)new MongoDBSpringBootTestResource());
    }

    private void thenConditionalIsEnabled() {
        Assertions.assertTrue((boolean)this.resource.isConditionalEnabled());
    }

    private void thenConditionalIsDisabled() {
        Assertions.assertFalse((boolean)this.resource.isConditionalEnabled());
    }
}

