/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers.springboot;

import java.util.Collections;
import java.util.Map;
import org.kie.kogito.kafka.KafkaClient;
import org.kie.kogito.resources.ConditionalSpringBootTestResource;
import org.kie.kogito.testcontainers.KogitoKafkaContainer;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.event.ContextClosedEvent;

public class KafkaSpringBootTestResource
extends ConditionalSpringBootTestResource<KogitoKafkaContainer> {
    public static final String KOGITO_KAFKA_PROPERTY = "spring.kafka.bootstrap-servers";
    private KafkaClient kafkaClient = null;

    public KafkaSpringBootTestResource() {
        super(new KogitoKafkaContainer());
    }

    @Override
    protected Map<String, String> getProperties() {
        return Collections.singletonMap(KOGITO_KAFKA_PROPERTY, "localhost:" + ((KogitoKafkaContainer)this.getTestResource()).getMappedPort());
    }

    @Override
    protected void updateBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.updateBeanFactory(beanFactory);
        if (!beanFactory.containsBean(KafkaClient.class.getName())) {
            this.kafkaClient = new KafkaClient("localhost:" + ((KogitoKafkaContainer)this.getTestResource()).getMappedPort());
            beanFactory.registerSingleton(KafkaClient.class.getName(), (Object)this.kafkaClient);
        }
    }

    @Override
    public void onApplicationEvent(ContextClosedEvent event) {
        if (this.kafkaClient != null) {
            this.kafkaClient.shutdown();
        }
        super.onApplicationEvent(event);
    }

    public static class Conditional
    extends KafkaSpringBootTestResource {
        public Conditional() {
            this.enableConditional();
        }
    }
}

