/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.timer.impl;

import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.timer.impl.SimpleTimerTrigger;

class SimpleTimerTriggerTest {
    public static final OffsetDateTime TRIGGER_START_TIME = OffsetDateTime.parse("2023-03-06T14:00:00.000+05:00");
    public static final OffsetDateTime TRIGGER_END_TIME = OffsetDateTime.parse("2023-03-06T19:00:00.000+05:00");
    public static final long PERIOD = 10L;

    SimpleTimerTriggerTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"simpleTimerTriggerParams"})
    void simpleTimerTrigger(OffsetDateTime startTimeAsOffsetDateTime, long period, ChronoUnit periodUnit, int repeatCount, OffsetDateTime endTimeAsOffsetDateTime, String offsetId, int expectedCurrentRepeatCount, OffsetDateTime[] expectedExecutions) {
        Date startTime = Date.from(startTimeAsOffsetDateTime.toInstant());
        Date endTime = endTimeAsOffsetDateTime != null ? Date.from(endTimeAsOffsetDateTime.toInstant()) : null;
        SimpleTimerTrigger trigger = endTime != null ? new SimpleTimerTrigger(startTime, period, periodUnit, repeatCount, endTime, offsetId) : new SimpleTimerTrigger(startTime, period, periodUnit, repeatCount, offsetId);
        ArrayList<Date> nextFireTimes = new ArrayList<Date>();
        while (trigger.hasNextFireTime() != null) {
            nextFireTimes.add(trigger.nextFireTime());
        }
        Assertions.assertThat((int)trigger.getCurrentRepeatCount()).isEqualTo(expectedCurrentRepeatCount);
        Assertions.assertThat(nextFireTimes).hasSize(expectedExecutions.length);
        for (int i = 0; i < expectedExecutions.length; ++i) {
            Assertions.assertThat((Date)((Date)nextFireTimes.get(i))).isEqualTo(expectedExecutions[i].toInstant());
            OffsetDateTime nextFireTimeAsOffsetDateTime = OffsetDateTime.ofInstant(((Date)nextFireTimes.get(i)).toInstant(), ZoneOffset.of(trigger.getZoneId()));
            Assertions.assertThat((OffsetDateTime)nextFireTimeAsOffsetDateTime).isEqualTo((Object)expectedExecutions[i]);
        }
        if (trigger.isIndefinitely()) {
            Assertions.assertThat((int)trigger.getRepeatCount()).isEqualTo(-1);
        }
    }

    private static Stream<Arguments> simpleTimerTriggerParams() {
        return Stream.of(Arguments.of((Object[])new Object[]{TRIGGER_START_TIME, 10L, ChronoUnit.MILLIS, 0, null, TRIGGER_START_TIME.getOffset().getId(), 0, new OffsetDateTime[]{TRIGGER_START_TIME}}), Arguments.of((Object[])new Object[]{TRIGGER_START_TIME, 10L, ChronoUnit.MILLIS, 1, null, TRIGGER_START_TIME.getOffset().getId(), 1, new OffsetDateTime[]{TRIGGER_START_TIME, TRIGGER_START_TIME.plus(10L, ChronoUnit.MILLIS)}}), Arguments.of((Object[])new Object[]{TRIGGER_START_TIME, 10L, ChronoUnit.MILLIS, 2, null, TRIGGER_START_TIME.getOffset().getId(), 2, new OffsetDateTime[]{TRIGGER_START_TIME, TRIGGER_START_TIME.plus(10L, ChronoUnit.MILLIS), TRIGGER_START_TIME.plus(20L, ChronoUnit.MILLIS)}}), Arguments.of((Object[])new Object[]{TRIGGER_START_TIME, 10L, ChronoUnit.MILLIS, 3, null, TRIGGER_START_TIME.getOffset().getId(), 3, new OffsetDateTime[]{TRIGGER_START_TIME, TRIGGER_START_TIME.plus(10L, ChronoUnit.MILLIS), TRIGGER_START_TIME.plus(20L, ChronoUnit.MILLIS), TRIGGER_START_TIME.plus(30L, ChronoUnit.MILLIS)}}), Arguments.of((Object[])new Object[]{TRIGGER_START_TIME, 10L, ChronoUnit.SECONDS, 0, null, TRIGGER_START_TIME.getOffset().getId(), 0, new OffsetDateTime[]{TRIGGER_START_TIME}}), Arguments.of((Object[])new Object[]{TRIGGER_START_TIME, 10L, ChronoUnit.SECONDS, 1, null, TRIGGER_START_TIME.getOffset().getId(), 1, new OffsetDateTime[]{TRIGGER_START_TIME, TRIGGER_START_TIME.plus(10L, ChronoUnit.SECONDS)}}), Arguments.of((Object[])new Object[]{TRIGGER_START_TIME, 10L, ChronoUnit.SECONDS, 2, null, TRIGGER_START_TIME.getOffset().getId(), 2, new OffsetDateTime[]{TRIGGER_START_TIME, TRIGGER_START_TIME.plus(10L, ChronoUnit.SECONDS), TRIGGER_START_TIME.plus(20L, ChronoUnit.SECONDS)}}), Arguments.of((Object[])new Object[]{TRIGGER_START_TIME, 10L, ChronoUnit.SECONDS, 3, null, TRIGGER_START_TIME.getOffset().getId(), 3, new OffsetDateTime[]{TRIGGER_START_TIME, TRIGGER_START_TIME.plus(10L, ChronoUnit.SECONDS), TRIGGER_START_TIME.plus(20L, ChronoUnit.SECONDS), TRIGGER_START_TIME.plus(30L, ChronoUnit.SECONDS)}}), Arguments.of((Object[])new Object[]{TRIGGER_START_TIME, 10L, ChronoUnit.MINUTES, 0, null, TRIGGER_START_TIME.getOffset().getId(), 0, new OffsetDateTime[]{TRIGGER_START_TIME}}), Arguments.of((Object[])new Object[]{TRIGGER_START_TIME, 10L, ChronoUnit.MINUTES, 1, null, TRIGGER_START_TIME.getOffset().getId(), 1, new OffsetDateTime[]{TRIGGER_START_TIME, TRIGGER_START_TIME.plus(10L, ChronoUnit.MINUTES)}}), Arguments.of((Object[])new Object[]{TRIGGER_START_TIME, 10L, ChronoUnit.MINUTES, 2, null, TRIGGER_START_TIME.getOffset().getId(), 2, new OffsetDateTime[]{TRIGGER_START_TIME, TRIGGER_START_TIME.plus(10L, ChronoUnit.MINUTES), TRIGGER_START_TIME.plus(20L, ChronoUnit.MINUTES)}}), Arguments.of((Object[])new Object[]{TRIGGER_START_TIME, 10L, ChronoUnit.MINUTES, 3, null, TRIGGER_START_TIME.getOffset().getId(), 3, new OffsetDateTime[]{TRIGGER_START_TIME, TRIGGER_START_TIME.plus(10L, ChronoUnit.MINUTES), TRIGGER_START_TIME.plus(20L, ChronoUnit.MINUTES), TRIGGER_START_TIME.plus(30L, ChronoUnit.MINUTES)}}), Arguments.of((Object[])new Object[]{TRIGGER_START_TIME, 1, ChronoUnit.HOURS, 3, TRIGGER_END_TIME, TRIGGER_START_TIME.getOffset().getId(), 3, new OffsetDateTime[]{TRIGGER_START_TIME, TRIGGER_START_TIME.plus(1L, ChronoUnit.HOURS), TRIGGER_START_TIME.plus(2L, ChronoUnit.HOURS), TRIGGER_START_TIME.plus(3L, ChronoUnit.HOURS)}}), Arguments.of((Object[])new Object[]{TRIGGER_START_TIME, 1, ChronoUnit.HOURS, 8, TRIGGER_END_TIME, TRIGGER_START_TIME.getOffset().getId(), 5, new OffsetDateTime[]{TRIGGER_START_TIME, TRIGGER_START_TIME.plus(1L, ChronoUnit.HOURS), TRIGGER_START_TIME.plus(2L, ChronoUnit.HOURS), TRIGGER_START_TIME.plus(3L, ChronoUnit.HOURS), TRIGGER_START_TIME.plus(4L, ChronoUnit.HOURS), TRIGGER_START_TIME.plus(5L, ChronoUnit.HOURS)}}), Arguments.of((Object[])new Object[]{TRIGGER_START_TIME, 1, ChronoUnit.HOURS, -1, TRIGGER_END_TIME, TRIGGER_START_TIME.getOffset().getId(), -1, new OffsetDateTime[]{TRIGGER_START_TIME, TRIGGER_START_TIME.plus(1L, ChronoUnit.HOURS), TRIGGER_START_TIME.plus(2L, ChronoUnit.HOURS), TRIGGER_START_TIME.plus(3L, ChronoUnit.HOURS), TRIGGER_START_TIME.plus(4L, ChronoUnit.HOURS), TRIGGER_START_TIME.plus(5L, ChronoUnit.HOURS)}}));
    }
}

