/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.dmn.core.impl.DMNContextImpl;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.impl.DMNResultImpl;
import org.kie.kogito.decision.DecisionExecutionIdUtils;
import org.kie.kogito.dmn.DMNKogito;
import org.kie.kogito.dmn.DmnDecisionModel;
import org.kie.kogito.tracing.decision.DecisionTracingListener;
import org.kie.kogito.tracing.decision.event.AfterEvaluateAllEvent;
import org.kie.kogito.tracing.decision.event.BeforeEvaluateAllEvent;
import org.kie.kogito.tracing.decision.event.EvaluateEvent;
import org.kie.kogito.tracing.decision.mock.MockAfterEvaluateAllEvent;
import org.kie.kogito.tracing.decision.mock.MockBeforeEvaluateAllEvent;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DecisionTracingListenerTest {
    private static final String TEST_EXECUTION_ID_1 = "e3140fbb-49fd-4835-bb2e-682bbe02d862";
    private static final String TEST_EXECUTION_ID_2 = "77408667-f218-40b0-a355-1bab047a3e9e";

    @Test
    public void test_Listener_UseMockedEvents_Working() {
        DMNContextImpl context = new DMNContextImpl();
        DecisionExecutionIdUtils.inject((DMNContext)context, () -> TEST_EXECUTION_ID_1);
        DMNResultImpl result = new DMNResultImpl((DMNModel)new DMNModelImpl());
        result.setContext((DMNContext)context);
        MockBeforeEvaluateAllEvent beforeEvent = new MockBeforeEvaluateAllEvent("modelNamespace", "modelName", (DMNResult)result);
        MockAfterEvaluateAllEvent afterEvent = new MockAfterEvaluateAllEvent("modelNamespace", "modelName", (DMNResult)result);
        Consumer eventConsumer = (Consumer)Mockito.mock(Consumer.class);
        DecisionTracingListener listener = new DecisionTracingListener(eventConsumer);
        listener.beforeEvaluateAll((org.kie.dmn.api.core.event.BeforeEvaluateAllEvent)beforeEvent);
        listener.afterEvaluateAll((org.kie.dmn.api.core.event.AfterEvaluateAllEvent)afterEvent);
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(EvaluateEvent.class);
        ((Consumer)Mockito.verify((Object)eventConsumer, (VerificationMode)Mockito.times((int)2))).accept((EvaluateEvent)eventCaptor.capture());
        DecisionTracingListenerTest.assertEvaluateEvents(eventCaptor.getAllValues(), "modelNamespace", "modelName", TEST_EXECUTION_ID_1);
    }

    @Test
    public void test_Listener_UseRealEvents_Working() {
        String modelResource = "/Traffic Violation.dmn";
        String modelNamespace = "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF";
        String modelName = "Traffic Violation";
        DMNRuntime runtime = DMNKogito.createGenericDMNRuntime((Reader[])new Reader[]{new InputStreamReader(DecisionTracingListenerTest.class.getResourceAsStream("/Traffic Violation.dmn"))});
        Consumer eventConsumer = (Consumer)Mockito.mock(Consumer.class);
        DecisionTracingListener listener = new DecisionTracingListener(eventConsumer);
        runtime.addListener((DMNRuntimeEventListener)listener);
        HashMap<String, Integer> driver = new HashMap<String, Integer>();
        driver.put("Points", 10);
        HashMap<String, Object> violation = new HashMap<String, Object>();
        violation.put("Type", "speed");
        violation.put("Actual Speed", 105);
        violation.put("Speed Limit", 100);
        HashMap<String, HashMap<String, Object>> contextVariables = new HashMap<String, HashMap<String, Object>>();
        contextVariables.put("Driver", driver);
        contextVariables.put("Violation", violation);
        DmnDecisionModel model = new DmnDecisionModel(runtime, "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation", () -> TEST_EXECUTION_ID_2);
        DMNContext context = model.newContext(contextVariables);
        model.evaluateAll(context);
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(EvaluateEvent.class);
        ((Consumer)Mockito.verify((Object)eventConsumer, (VerificationMode)Mockito.times((int)2))).accept((EvaluateEvent)eventCaptor.capture());
        DecisionTracingListenerTest.assertEvaluateEvents(eventCaptor.getAllValues(), "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation", TEST_EXECUTION_ID_2);
    }

    private static void assertEvaluateEvents(List<EvaluateEvent> evaluateEvents, String modelNamespace, String modelName, String executionId) {
        Assertions.assertEquals((int)2, (int)evaluateEvents.size());
        Assertions.assertTrue((boolean)(evaluateEvents.get(0) instanceof BeforeEvaluateAllEvent));
        Assertions.assertTrue((boolean)(evaluateEvents.get(1) instanceof AfterEvaluateAllEvent));
        BeforeEvaluateAllEvent beforeEvaluateAllEvent = (BeforeEvaluateAllEvent)evaluateEvents.get(0);
        Assertions.assertEquals((Object)executionId, (Object)beforeEvaluateAllEvent.getExecutionId());
        Assertions.assertEquals((Object)modelName, (Object)beforeEvaluateAllEvent.getModelName());
        Assertions.assertEquals((Object)modelNamespace, (Object)beforeEvaluateAllEvent.getModelNamespace());
        AfterEvaluateAllEvent afterEvaluateAllEvent = (AfterEvaluateAllEvent)evaluateEvents.get(1);
        Assertions.assertEquals((Object)executionId, (Object)afterEvaluateAllEvent.getExecutionId());
        Assertions.assertEquals((Object)modelName, (Object)afterEvaluateAllEvent.getModelName());
        Assertions.assertEquals((Object)modelNamespace, (Object)afterEvaluateAllEvent.getModelNamespace());
    }
}

