/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision.event;

import java.util.Map;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNResult;
import org.kie.kogito.tracing.decision.event.EvaluateEventResult;

public abstract class EvaluateEvent {
    private final String executionId;
    private final String modelName;
    private final String modelNamespace;
    private final Map<String, Object> context;
    private final Map<String, Object> contextMetadata;
    private final EvaluateEventResult result;

    public EvaluateEvent(String executionId, String modelName, String modelNamespace, DMNContext context) {
        DMNContext clone = context.clone();
        this.executionId = executionId;
        this.modelName = modelName;
        this.modelNamespace = modelNamespace;
        this.context = clone.getAll();
        this.contextMetadata = clone.getMetadata().asMap();
        this.result = null;
    }

    public EvaluateEvent(String executionId, String modelName, String modelNamespace, DMNResult result) {
        DMNContext clone = result.getContext().clone();
        this.executionId = executionId;
        this.modelName = modelName;
        this.modelNamespace = modelNamespace;
        this.context = clone.getAll();
        this.contextMetadata = clone.getMetadata().asMap();
        this.result = EvaluateEventResult.from(result);
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getModelNamespace() {
        return this.modelNamespace;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public Map<String, Object> getContextMetadata() {
        return this.contextMetadata;
    }

    public EvaluateEventResult getResult() {
        return this.result;
    }
}

