/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision;

import io.cloudevents.json.Json;
import io.cloudevents.v1.CloudEventImpl;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.dmn.feel.util.Pair;
import org.kie.kogito.tracing.decision.DecisionTracingCollector;
import org.kie.kogito.tracing.decision.aggregator.Aggregator;
import org.kie.kogito.tracing.decision.event.AfterEvaluateAllEvent;
import org.kie.kogito.tracing.decision.event.EvaluateEvent;
import org.kie.kogito.tracing.decision.mock.MockDefaultAggregator;
import org.kie.kogito.tracing.decision.mock.MockUtils;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DecisionTracingCollectorTest {
    private static final String TEST_EXECUTION_ID_1 = "c91da8ec-05f7-4dbd-adf4-c7aa88f7888b";
    private static final String TEST_EXECUTION_ID_2 = "550e2947-0952-4225-81a0-ea6e1064efd2";

    @Test
    public void test_Collector_InterleavedEvaluations_Working() {
        MockDefaultAggregator aggregator = new MockDefaultAggregator();
        Consumer payloadConsumer = (Consumer)Mockito.mock(Consumer.class);
        DecisionTracingCollector collector = new DecisionTracingCollector((Aggregator)aggregator, payloadConsumer);
        collector.addEvent((EvaluateEvent)MockUtils.beforeEvaluateAllEvent(TEST_EXECUTION_ID_1));
        collector.addEvent((EvaluateEvent)MockUtils.beforeEvaluateAllEvent(TEST_EXECUTION_ID_2));
        collector.addEvent((EvaluateEvent)MockUtils.afterEvaluateAllEvent(TEST_EXECUTION_ID_1));
        collector.addEvent((EvaluateEvent)MockUtils.afterEvaluateAllEvent(TEST_EXECUTION_ID_2));
        Map<String, Pair<List<EvaluateEvent>, CloudEventImpl<AfterEvaluateAllEvent>>> aggregatorCalls = aggregator.getCalls();
        Assertions.assertEquals((int)2, (int)aggregatorCalls.size());
        Assertions.assertTrue((boolean)aggregatorCalls.containsKey(TEST_EXECUTION_ID_1));
        Assertions.assertEquals((int)2, (int)((List)aggregatorCalls.get(TEST_EXECUTION_ID_1).getLeft()).size());
        Assertions.assertTrue((boolean)aggregatorCalls.containsKey(TEST_EXECUTION_ID_2));
        Assertions.assertEquals((int)2, (int)((List)aggregatorCalls.get(TEST_EXECUTION_ID_2).getLeft()).size());
        ArgumentCaptor payloadCaptor = ArgumentCaptor.forClass(String.class);
        ((Consumer)Mockito.verify((Object)payloadConsumer, (VerificationMode)Mockito.times((int)2))).accept((String)payloadCaptor.capture());
        List payloads = payloadCaptor.getAllValues();
        Assertions.assertEquals((Object)Json.encode((Object)aggregatorCalls.get(TEST_EXECUTION_ID_1).getRight()), payloads.get(0));
        Assertions.assertEquals((Object)Json.encode((Object)aggregatorCalls.get(TEST_EXECUTION_ID_2).getRight()), payloads.get(1));
    }
}

