/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision.aggregator;

import io.cloudevents.v1.CloudEventImpl;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.tracing.decision.aggregator.DefaultAggregator;
import org.kie.kogito.tracing.decision.event.AfterEvaluateAllEvent;
import org.kie.kogito.tracing.decision.event.BeforeEvaluateAllEvent;
import org.kie.kogito.tracing.decision.mock.MockUtils;

public class DefaultAggregatorTest {
    private static final String TEST_EXECUTION_ID = "4ac4c69f-4925-4221-b67e-4b14ce47bef8";

    @Test
    public void test_Aggregate_ValidList_Working() {
        DefaultAggregator aggregator = new DefaultAggregator();
        List<AfterEvaluateAllEvent> events = List.of(MockUtils.beforeEvaluateAllEvent(TEST_EXECUTION_ID), MockUtils.afterEvaluateAllEvent(TEST_EXECUTION_ID));
        CloudEventImpl cloudEvent = aggregator.aggregate(TEST_EXECUTION_ID, events);
        Assertions.assertEquals((Object)TEST_EXECUTION_ID, (Object)cloudEvent.getAttributes().getId());
        Assertions.assertEquals((Object)AfterEvaluateAllEvent.class.getName(), (Object)cloudEvent.getAttributes().getType());
    }

    @Test
    public void test_Aggregate_NullList_ExceptionThrown() {
        DefaultAggregator aggregator = new DefaultAggregator();
        Assertions.assertThrows(IllegalStateException.class, () -> aggregator.aggregate(TEST_EXECUTION_ID, null));
    }

    @Test
    public void test_Aggregate_EmptyList_ExceptionThrown() {
        DefaultAggregator aggregator = new DefaultAggregator();
        Assertions.assertThrows(IllegalStateException.class, () -> aggregator.aggregate(TEST_EXECUTION_ID, Collections.emptyList()));
    }

    @Test
    public void test_Aggregate_ListWithoutAfterEvaluateAllEvent_ExceptionThrown() {
        DefaultAggregator aggregator = new DefaultAggregator();
        List<BeforeEvaluateAllEvent> events = List.of(MockUtils.beforeEvaluateAllEvent(TEST_EXECUTION_ID));
        Assertions.assertThrows(IllegalStateException.class, () -> aggregator.aggregate(TEST_EXECUTION_ID, events));
    }
}

