/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision.aggregator;

import java.util.LinkedList;
import java.util.List;
import org.kie.kogito.tracing.decision.event.evaluate.EvaluateEvent;
import org.kie.kogito.tracing.decision.event.evaluate.EvaluateEventType;
import org.kie.kogito.tracing.decision.event.trace.TraceExecutionStep;

public class DefaultAggregatorStackEntry {
    private final EvaluateEvent beforeEvent;
    private final List<TraceExecutionStep> children;

    public DefaultAggregatorStackEntry(EvaluateEvent beforeEvent) {
        if (!beforeEvent.getType().isBefore()) {
            throw new IllegalStateException(String.format("%s is not a valid \"before\" event", beforeEvent.getType().name()));
        }
        this.beforeEvent = beforeEvent;
        this.children = new LinkedList<TraceExecutionStep>();
    }

    public EvaluateEvent getBeforeEvent() {
        return this.beforeEvent;
    }

    public List<TraceExecutionStep> getChildren() {
        return this.children;
    }

    public void addChild(TraceExecutionStep child) {
        this.children.add(child);
    }

    public boolean isValidAfterEvent(EvaluateEvent afterEvent) {
        switch (afterEvent.getType()) {
            case AFTER_EVALUATE_CONTEXT_ENTRY: {
                return this.beforeEvent.getType() == EvaluateEventType.BEFORE_EVALUATE_CONTEXT_ENTRY && DefaultAggregatorStackEntry.stringEquals(this.beforeEvent.getNodeName(), afterEvent.getNodeName());
            }
            case AFTER_EVALUATE_DECISION_TABLE: {
                return this.beforeEvent.getType() == EvaluateEventType.BEFORE_EVALUATE_DECISION_TABLE && DefaultAggregatorStackEntry.stringEquals(this.beforeEvent.getNodeName(), afterEvent.getNodeName());
            }
            case AFTER_EVALUATE_DECISION: {
                return this.beforeEvent.getType() == EvaluateEventType.BEFORE_EVALUATE_DECISION && DefaultAggregatorStackEntry.stringEquals(this.beforeEvent.getNodeId(), afterEvent.getNodeId());
            }
            case AFTER_EVALUATE_DECISION_SERVICE: {
                return this.beforeEvent.getType() == EvaluateEventType.BEFORE_EVALUATE_DECISION_SERVICE && DefaultAggregatorStackEntry.stringEquals(this.beforeEvent.getNodeId(), afterEvent.getNodeId());
            }
            case AFTER_EVALUATE_BKM: {
                return this.beforeEvent.getType() == EvaluateEventType.BEFORE_EVALUATE_BKM && DefaultAggregatorStackEntry.stringEquals(this.beforeEvent.getNodeId(), afterEvent.getNodeId());
            }
            case AFTER_INVOKE_BKM: {
                return this.beforeEvent.getType() == EvaluateEventType.BEFORE_INVOKE_BKM && DefaultAggregatorStackEntry.stringEquals(this.beforeEvent.getNodeId(), afterEvent.getNodeId());
            }
        }
        return false;
    }

    public static boolean isValidBeforeEvent(EvaluateEvent beforeEvent) {
        switch (beforeEvent.getType()) {
            case BEFORE_EVALUATE_CONTEXT_ENTRY: 
            case BEFORE_EVALUATE_DECISION_TABLE: 
            case BEFORE_EVALUATE_DECISION: 
            case BEFORE_EVALUATE_DECISION_SERVICE: 
            case BEFORE_EVALUATE_BKM: 
            case BEFORE_INVOKE_BKM: {
                return true;
            }
        }
        return false;
    }

    private static boolean stringEquals(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s1.equals(s2);
    }
}

