/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travel;

import io.quarkus.test.junit.QuarkusTest;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.acme.travels.Address;
import org.acme.travels.Flight;
import org.acme.travels.Hotel;
import org.acme.travels.Traveller;
import org.acme.travels.Trip;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Model;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policy;

@QuarkusTest
public class TravelTest {
    @Inject
    @Named(value="travels")
    Process<? extends Model> travelsProcess;

    @Test
    public void testTravelNoVisaRequired() {
        Assertions.assertNotNull(this.travelsProcess);
        Model m = (Model)this.travelsProcess.createModel();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("traveller", new Traveller("John", "Doe", "john.doe@example.com", "American", new Address("main street", "Boston", "10005", "US")));
        parameters.put("trip", new Trip("New York", "US", new Date(), new Date()));
        m.fromMap(parameters);
        ProcessInstance processInstance = this.travelsProcess.createInstance(m);
        processInstance.start();
        Assertions.assertEquals((int)1, (int)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assertions.assertEquals((int)4, (int)result.toMap().size());
        Hotel hotel = (Hotel)result.toMap().get("hotel");
        Assertions.assertNotNull((Object)hotel);
        Assertions.assertEquals((Object)"Perfect hotel", (Object)hotel.getName());
        Assertions.assertEquals((Object)"XX-012345", (Object)hotel.getBookingNumber());
        Assertions.assertEquals((Object)"09876543", (Object)hotel.getPhone());
        Flight flight = (Flight)result.toMap().get("flight");
        Assertions.assertNotNull((Object)flight);
        Assertions.assertEquals((Object)"MX555", (Object)flight.getFlightNumber());
        Assertions.assertNotNull((Object)flight.getArrival());
        Assertions.assertNotNull((Object)flight.getDeparture());
        List workItems = processInstance.workItems(new Policy[0]);
        Assertions.assertEquals((int)1, (int)workItems.size());
        Assertions.assertEquals((Object)"ConfirmTravel", (Object)((WorkItem)workItems.get(0)).getName());
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), null, new Policy[0]);
        Assertions.assertEquals((int)2, (int)processInstance.status());
    }

    @Test
    public void testTravelVisaRequired() {
        Assertions.assertNotNull(this.travelsProcess);
        Model m = (Model)this.travelsProcess.createModel();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Traveller requested = new Traveller("Jan", "Kowalski", "jan.kowalski@example.com", "Polish", new Address("polna", "Krakow", "32000", "Poland"));
        parameters.put("traveller", requested);
        parameters.put("trip", new Trip("New York", "US", new Date(), new Date()));
        m.fromMap(parameters);
        ProcessInstance processInstance = this.travelsProcess.createInstance(m);
        processInstance.start();
        Assertions.assertEquals((int)1, (int)processInstance.status());
        List workItems = processInstance.workItems(new Policy[0]);
        Assertions.assertEquals((int)1, (int)workItems.size());
        Assertions.assertEquals((Object)"VisaApplication", (Object)((WorkItem)workItems.get(0)).getName());
        String visaApplication = "http://mydrive.example.com/docs/u324dx";
        Map<String, String> params = Collections.singletonMap("visaApplication", visaApplication);
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), params, new Policy[0]);
        Assertions.assertEquals((int)1, (int)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assertions.assertEquals((int)4, (int)result.toMap().size());
        Traveller traveller = (Traveller)result.toMap().get("traveller");
        Assertions.assertNotNull((Object)traveller);
        Assertions.assertEquals((Object)requested.getFirstName(), (Object)traveller.getFirstName());
        Assertions.assertEquals((Object)requested.getLastName(), (Object)traveller.getLastName());
        Assertions.assertEquals((Object)requested.getEmail(), (Object)traveller.getEmail());
        Assertions.assertEquals((Object)requested.getNationality(), (Object)traveller.getNationality());
        Assertions.assertEquals((Object)requested.getAddress().getCity(), (Object)traveller.getAddress().getCity());
        Assertions.assertEquals((Object)requested.getAddress().getCountry(), (Object)traveller.getAddress().getCountry());
        Assertions.assertEquals((Object)requested.getAddress().getStreet(), (Object)traveller.getAddress().getStreet());
        Assertions.assertEquals((Object)requested.getAddress().getZipCode(), (Object)traveller.getAddress().getZipCode());
        Assertions.assertEquals((Object)visaApplication, (Object)traveller.getVisaApplication());
        Hotel hotel = (Hotel)result.toMap().get("hotel");
        Assertions.assertNotNull((Object)hotel);
        Assertions.assertEquals((Object)"Perfect hotel", (Object)hotel.getName());
        Assertions.assertEquals((Object)"XX-012345", (Object)hotel.getBookingNumber());
        Assertions.assertEquals((Object)"09876543", (Object)hotel.getPhone());
        Flight flight = (Flight)result.toMap().get("flight");
        Assertions.assertNotNull((Object)flight);
        Assertions.assertEquals((Object)"MX555", (Object)flight.getFlightNumber());
        Assertions.assertNotNull((Object)flight.getArrival());
        Assertions.assertNotNull((Object)flight.getDeparture());
        workItems = processInstance.workItems(new Policy[0]);
        Assertions.assertEquals((int)1, (int)workItems.size());
        Assertions.assertEquals((Object)"ConfirmTravel", (Object)((WorkItem)workItems.get(0)).getName());
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), null, new Policy[0]);
        Assertions.assertEquals((int)2, (int)processInstance.status());
    }
}

