/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travels;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class ApprovalsRestTest {
    @Test
    public void testStartApprovalUnauthorized() {
        ((ValidatableResponse)((Response)RestAssured.given().body("{\"traveller\" : {\"firstName\" : \"John\",\"lastName\" : \"Doe\",\"email\" : \"john.doe@example.com\",\"nationality\" : \"American\",\"address\" : {\"street\" : \"main street\",\"city\" : \"Boston\",\"zipCode\" : \"10005\",\"country\" : \"US\"}}}").contentType(ContentType.JSON).when().post("/approvals", new Object[0])).then()).statusCode(401);
    }

    @Test
    public void testStartApprovalAuthorized() {
        String id = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Authorization", (Object)"Basic am9objpqb2hu", new Object[0]).body("{\"traveller\" : {\"firstName\" : \"John\",\"lastName\" : \"Doe\",\"email\" : \"john.doe@example.com\",\"nationality\" : \"American\",\"address\" : {\"street\" : \"main street\",\"city\" : \"Boston\",\"zipCode\" : \"10005\",\"country\" : \"US\"}}}").contentType(ContentType.JSON).when().post("/approvals", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.notNullValue(), new Object[0])).extract().path("id", new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Authorization", (Object)"Basic am9objpqb2hu", new Object[0]).accept(ContentType.JSON).when().get("/approvals", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[]{"[0].id", CoreMatchers.is((Object)id)});
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Authorization", (Object)"Basic am9objpqb2hu", new Object[0]).accept(ContentType.JSON).when().get("/approvals/" + id, new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)id), new Object[0]);
        Map taskInfo = (Map)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Authorization", (Object)"Basic am9objpqb2hu", new Object[0]).accept(ContentType.JSON).when().get("/approvals/" + id + "/tasks?user=admin&group=managers", new Object[0])).then()).statusCode(200)).extract().as(Map.class);
        Assertions.assertEquals((int)1, (int)taskInfo.size());
        taskInfo.containsValue("firstLineApproval");
        String payload = "{}";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(payload).when().post("/approvals/" + id + "/firstLineApproval/" + taskInfo.keySet().iterator().next() + "?user=mary&group=managers", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)id), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Authorization", (Object)"Basic am9objpqb2hu", new Object[0]).accept(ContentType.JSON).when().delete("/approvals/" + id, new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)id), new Object[0]);
    }
}

