/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.streams.stages;

import io.reactivex.Flowable;
import io.reactivex.plugins.RxJavaPlugins;
import io.smallrye.reactive.streams.Engine;
import io.smallrye.reactive.streams.operators.ProcessingStage;
import io.smallrye.reactive.streams.operators.ProcessingStageFactory;
import io.smallrye.reactive.streams.utils.recovery.OnErrorResumeWith;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.streams.operators.spi.Graph;
import org.eclipse.microprofile.reactive.streams.operators.spi.Stage;

public class OnErrorResumeWithStageFactory
implements ProcessingStageFactory<Stage.OnErrorResumeWith> {
    @Override
    public <I, O> ProcessingStage<I, O> create(Engine engine, Stage.OnErrorResumeWith stage) {
        Function<Throwable, Graph> function = Objects.requireNonNull(stage).getFunction();
        Objects.requireNonNull(function);
        return source -> RxJavaPlugins.onAssembly(new OnErrorResumeWith(source, err -> {
            Graph graph = (Graph)function.apply((Throwable)err);
            return Flowable.fromPublisher(Objects.requireNonNull(engine.buildPublisher(Objects.requireNonNull(graph))));
        }));
    }
}

