/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.streams.utils;

import java.util.Objects;
import org.reactivestreams.Subscription;

public class WrappedSubscription
implements Subscription {
    private final Subscription subscription;
    private final Runnable cancellationHandler;

    WrappedSubscription(Subscription subscription, Runnable onCancellation) {
        this.subscription = Objects.requireNonNull(subscription);
        this.cancellationHandler = onCancellation;
    }

    @Override
    public void request(long n) {
        this.subscription.request(n);
    }

    @Override
    public void cancel() {
        if (this.cancellationHandler != null) {
            this.cancellationHandler.run();
        }
        this.subscription.cancel();
    }
}

