/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.http;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MultiHelper;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.http.WebSocketBase;
import io.vertx.mutiny.core.http.WebSocketFrame;
import io.vertx.mutiny.core.net.SocketAddress;
import io.vertx.mutiny.core.streams.Pipe;
import io.vertx.mutiny.core.streams.WriteStream;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.net.ssl.SSLSession;

class WebSocketBaseImpl
implements WebSocketBase {
    private final io.vertx.core.http.WebSocketBase delegate;
    private Multi<Buffer> multi;
    private SocketAddress cached_0;
    private SocketAddress cached_1;

    @Override
    public io.vertx.core.http.WebSocketBase getDelegate() {
        return this.delegate;
    }

    WebSocketBaseImpl() {
        this.delegate = null;
    }

    public WebSocketBaseImpl(io.vertx.core.http.WebSocketBase delegate) {
        this.delegate = delegate;
    }

    @Override
    public synchronized Multi<Buffer> toMulti() {
        if (this.multi == null) {
            Function<io.vertx.core.buffer.Buffer, Buffer> conv = Buffer::newInstance;
            this.multi = MultiHelper.toMulti(this.delegate, conv);
        }
        return this.multi;
    }

    public Iterable<Buffer> toBlockingIterable() {
        return this.toMulti().subscribe().asIterable();
    }

    public Stream<Buffer> toBlockingStream() {
        return this.toMulti().subscribe().asStream();
    }

    private void __end(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(data.getDelegate(), handler);
    }

    @Override
    public Uni<Void> end(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.__end(data, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void endAndAwait(Buffer data) {
        return this.end(data).await().indefinitely();
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public Pipe<Buffer> pipe() {
        Pipe<Buffer> ret = Pipe.newInstance(this.delegate.pipe(), Buffer.__TYPE_ARG);
        return ret;
    }

    private void __pipeTo(WriteStream<Buffer> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    @Override
    public Uni<Void> pipeTo(WriteStream<Buffer> dst) {
        return AsyncResultUni.toUni(handler -> this.__pipeTo(dst, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void pipeToAndAwait(WriteStream<Buffer> dst) {
        return this.pipeTo(dst).await().indefinitely();
    }

    private WebSocketBase __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler((Handler)handler);
        return this;
    }

    @Override
    public WebSocketBase exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler(handler != null ? handler::accept : null);
    }

    private WebSocketBase __handler(final Handler<Buffer> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.core.buffer.Buffer>(){

            @Override
            public void handle(io.vertx.core.buffer.Buffer event) {
                handler.handle(Buffer.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public WebSocketBase handler(Consumer<Buffer> handler) {
        return this.__handler(handler != null ? handler::accept : null);
    }

    @Override
    public WebSocketBase pause() {
        this.delegate.pause();
        return this;
    }

    @Override
    public WebSocketBase resume() {
        this.delegate.resume();
        return this;
    }

    @Override
    public WebSocketBase fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    private WebSocketBase __endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler((Handler)endHandler);
        return this;
    }

    @Override
    public WebSocketBase endHandler(Consumer<Void> endHandler) {
        return this.__endHandler(endHandler != null ? endHandler::accept : null);
    }

    private WebSocketBase __write(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(data.getDelegate(), handler);
        return this;
    }

    @Override
    public Uni<Void> write(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.__write(data, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void writeAndAwait(Buffer data) {
        return this.write(data).await().indefinitely();
    }

    @Override
    public WebSocketBase setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    private WebSocketBase __drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler((Handler)handler);
        return this;
    }

    @Override
    public WebSocketBase drainHandler(Consumer<Void> handler) {
        return this.__drainHandler(handler != null ? handler::accept : null);
    }

    @Override
    public String binaryHandlerID() {
        String ret = this.delegate.binaryHandlerID();
        return ret;
    }

    @Override
    public String textHandlerID() {
        String ret = this.delegate.textHandlerID();
        return ret;
    }

    @Override
    public String subProtocol() {
        String ret = this.delegate.subProtocol();
        return ret;
    }

    @Override
    public Short closeStatusCode() {
        Short ret = this.delegate.closeStatusCode();
        return ret;
    }

    @Override
    public String closeReason() {
        String ret = this.delegate.closeReason();
        return ret;
    }

    @Override
    public MultiMap headers() {
        MultiMap ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    private WebSocketBase __writeFrame(WebSocketFrame frame, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeFrame(frame.getDelegate(), handler);
        return this;
    }

    @Override
    public Uni<Void> writeFrame(WebSocketFrame frame) {
        return AsyncResultUni.toUni(handler -> this.__writeFrame(frame, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void writeFrameAndAwait(WebSocketFrame frame) {
        return this.writeFrame(frame).await().indefinitely();
    }

    private WebSocketBase __writeFinalTextFrame(String text, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeFinalTextFrame(text, handler);
        return this;
    }

    @Override
    public Uni<Void> writeFinalTextFrame(String text) {
        return AsyncResultUni.toUni(handler -> this.__writeFinalTextFrame(text, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void writeFinalTextFrameAndAwait(String text) {
        return this.writeFinalTextFrame(text).await().indefinitely();
    }

    private WebSocketBase __writeFinalBinaryFrame(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeFinalBinaryFrame(data.getDelegate(), handler);
        return this;
    }

    @Override
    public Uni<Void> writeFinalBinaryFrame(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.__writeFinalBinaryFrame(data, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void writeFinalBinaryFrameAndAwait(Buffer data) {
        return this.writeFinalBinaryFrame(data).await().indefinitely();
    }

    private WebSocketBase __writeBinaryMessage(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeBinaryMessage(data.getDelegate(), handler);
        return this;
    }

    @Override
    public Uni<Void> writeBinaryMessage(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.__writeBinaryMessage(data, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void writeBinaryMessageAndAwait(Buffer data) {
        return this.writeBinaryMessage(data).await().indefinitely();
    }

    private WebSocketBase __writeTextMessage(String text, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeTextMessage(text, handler);
        return this;
    }

    @Override
    public Uni<Void> writeTextMessage(String text) {
        return AsyncResultUni.toUni(handler -> this.__writeTextMessage(text, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void writeTextMessageAndAwait(String text) {
        return this.writeTextMessage(text).await().indefinitely();
    }

    @Override
    public WebSocketBase writePing(Buffer data) {
        this.delegate.writePing(data.getDelegate());
        return this;
    }

    @Override
    public WebSocketBase writePong(Buffer data) {
        this.delegate.writePong(data.getDelegate());
        return this;
    }

    private WebSocketBase __closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    @Override
    public WebSocketBase closeHandler(Consumer<Void> handler) {
        return this.__closeHandler(handler != null ? handler::accept : null);
    }

    private WebSocketBase __frameHandler(final Handler<WebSocketFrame> handler) {
        this.delegate.frameHandler(new Handler<io.vertx.core.http.WebSocketFrame>(){

            @Override
            public void handle(io.vertx.core.http.WebSocketFrame event) {
                handler.handle(WebSocketFrame.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public WebSocketBase frameHandler(Consumer<WebSocketFrame> handler) {
        return this.__frameHandler(handler != null ? handler::accept : null);
    }

    private WebSocketBase __textMessageHandler(Handler<String> handler) {
        this.delegate.textMessageHandler(handler);
        return this;
    }

    @Override
    public WebSocketBase textMessageHandler(Consumer<String> handler) {
        return this.__textMessageHandler(handler != null ? handler::accept : null);
    }

    private WebSocketBase __binaryMessageHandler(final Handler<Buffer> handler) {
        this.delegate.binaryMessageHandler(new Handler<io.vertx.core.buffer.Buffer>(){

            @Override
            public void handle(io.vertx.core.buffer.Buffer event) {
                handler.handle(Buffer.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public WebSocketBase binaryMessageHandler(Consumer<Buffer> handler) {
        return this.__binaryMessageHandler(handler != null ? handler::accept : null);
    }

    private WebSocketBase __pongHandler(final Handler<Buffer> handler) {
        this.delegate.pongHandler(new Handler<io.vertx.core.buffer.Buffer>(){

            @Override
            public void handle(io.vertx.core.buffer.Buffer event) {
                handler.handle(Buffer.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public WebSocketBase pongHandler(Consumer<Buffer> handler) {
        return this.__pongHandler(handler != null ? handler::accept : null);
    }

    private void __end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    @Override
    public Uni<Void> end() {
        return AsyncResultUni.toUni(handler -> this.__end((Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void endAndAwait() {
        return this.end().await().indefinitely();
    }

    private void __close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    @Override
    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.__close((Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void closeAndAwait() {
        return this.close().await().indefinitely();
    }

    private void __close(short statusCode, Handler<AsyncResult<Void>> handler) {
        this.delegate.close(statusCode, handler);
    }

    @Override
    public Uni<Void> close(short statusCode) {
        return AsyncResultUni.toUni(handler -> this.__close(statusCode, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void closeAndAwait(short statusCode) {
        return this.close(statusCode).await().indefinitely();
    }

    private void __close(short statusCode, String reason, Handler<AsyncResult<Void>> handler) {
        this.delegate.close(statusCode, reason, handler);
    }

    @Override
    public Uni<Void> close(short statusCode, String reason) {
        return AsyncResultUni.toUni(handler -> this.__close(statusCode, reason, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void closeAndAwait(short statusCode, String reason) {
        return this.close(statusCode, reason).await().indefinitely();
    }

    @Override
    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    @Override
    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    @Override
    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    @Override
    public boolean isClosed() {
        boolean ret = this.delegate.isClosed();
        return ret;
    }

    @Override
    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }

    public void endAndForget(Buffer data) {
        this.delegate.end(data.getDelegate());
    }

    public void pipeToAndForget(WriteStream<Buffer> dst) {
        this.delegate.pipeTo(dst.getDelegate());
    }

    public WebSocketBase writeAndForget(Buffer data) {
        this.delegate.write(data.getDelegate());
        return this;
    }

    public WebSocketBase writeFrameAndForget(WebSocketFrame frame) {
        this.delegate.writeFrame(frame.getDelegate());
        return this;
    }

    public WebSocketBase writeFinalTextFrameAndForget(String text) {
        this.delegate.writeFinalTextFrame(text);
        return this;
    }

    public WebSocketBase writeFinalBinaryFrameAndForget(Buffer data) {
        this.delegate.writeFinalBinaryFrame(data.getDelegate());
        return this;
    }

    public WebSocketBase writeBinaryMessageAndForget(Buffer data) {
        this.delegate.writeBinaryMessage(data.getDelegate());
        return this;
    }

    public WebSocketBase writeTextMessageAndForget(String text) {
        this.delegate.writeTextMessage(text);
        return this;
    }

    public void endAndForget() {
        this.delegate.end();
    }

    public void closeAndForget() {
        this.delegate.close();
    }

    public void closeAndForget(short statusCode) {
        this.delegate.close(statusCode);
    }

    public void closeAndForget(short statusCode, String reason) {
        this.delegate.close(statusCode, reason);
    }
}

