/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.parsetools;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MultiHelper;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.ReadStreamSubscriber;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.streams.Pipe;
import io.vertx.mutiny.core.streams.ReadStream;
import io.vertx.mutiny.core.streams.WriteStream;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;

@MutinyGen(value=io.vertx.core.parsetools.RecordParser.class)
public class RecordParser
implements ReadStream<Buffer>,
Handler<Buffer> {
    public static final TypeArg<RecordParser> __TYPE_ARG = new TypeArg<RecordParser>(obj -> new RecordParser((io.vertx.core.parsetools.RecordParser)obj), RecordParser::getDelegate);
    private final io.vertx.core.parsetools.RecordParser delegate;
    private Multi<Buffer> multi;

    public RecordParser(io.vertx.core.parsetools.RecordParser delegate) {
        this.delegate = delegate;
    }

    RecordParser() {
        this.delegate = null;
    }

    @Override
    public io.vertx.core.parsetools.RecordParser getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordParser that = (RecordParser)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public Pipe<Buffer> pipe() {
        Pipe<Buffer> ret = Pipe.newInstance(this.delegate.pipe(), Buffer.__TYPE_ARG);
        return ret;
    }

    private void __pipeTo(WriteStream<Buffer> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    @Override
    public Uni<Void> pipeTo(WriteStream<Buffer> dst) {
        return AsyncResultUni.toUni(handler -> this.__pipeTo(dst, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void pipeToAndAwait(WriteStream<Buffer> dst) {
        return this.pipeTo(dst).await().indefinitely();
    }

    private void __setOutput(final Handler<Buffer> output) {
        this.delegate.setOutput(new Handler<io.vertx.core.buffer.Buffer>(){

            @Override
            public void handle(io.vertx.core.buffer.Buffer event) {
                output.handle(Buffer.newInstance(event));
            }
        });
    }

    public void setOutput(Consumer<Buffer> output) {
        this.__setOutput(output != null ? output::accept : null);
    }

    private static RecordParser __newDelimited(String delim, final Handler<Buffer> output) {
        RecordParser ret = RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newDelimited(delim, new Handler<io.vertx.core.buffer.Buffer>(){

            @Override
            public void handle(io.vertx.core.buffer.Buffer event) {
                output.handle(Buffer.newInstance(event));
            }
        }));
        return ret;
    }

    public static RecordParser newDelimited(String delim, Consumer<Buffer> output) {
        return RecordParser.__newDelimited(delim, output != null ? output::accept : null);
    }

    public static RecordParser newDelimited(String delim, ReadStream<Buffer> stream) {
        RecordParser ret = RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newDelimited(delim, (io.vertx.core.streams.ReadStream<io.vertx.core.buffer.Buffer>)stream.getDelegate()));
        return ret;
    }

    public static RecordParser newDelimited(String delim, Publisher<Buffer> stream) {
        RecordParser ret = RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newDelimited(delim, ReadStreamSubscriber.asReadStream(stream, obj -> obj.getDelegate()).resume()));
        return ret;
    }

    public static RecordParser newDelimited(String delim) {
        RecordParser ret = RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newDelimited(delim));
        return ret;
    }

    public static RecordParser newDelimited(Buffer delim) {
        RecordParser ret = RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newDelimited(delim.getDelegate()));
        return ret;
    }

    private static RecordParser __newDelimited(Buffer delim, final Handler<Buffer> output) {
        RecordParser ret = RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newDelimited(delim.getDelegate(), new Handler<io.vertx.core.buffer.Buffer>(){

            @Override
            public void handle(io.vertx.core.buffer.Buffer event) {
                output.handle(Buffer.newInstance(event));
            }
        }));
        return ret;
    }

    public static RecordParser newDelimited(Buffer delim, Consumer<Buffer> output) {
        return RecordParser.__newDelimited(delim, output != null ? output::accept : null);
    }

    public static RecordParser newDelimited(Buffer delim, ReadStream<Buffer> stream) {
        RecordParser ret = RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newDelimited(delim.getDelegate(), (io.vertx.core.streams.ReadStream<io.vertx.core.buffer.Buffer>)stream.getDelegate()));
        return ret;
    }

    public static RecordParser newDelimited(Buffer delim, Publisher<Buffer> stream) {
        RecordParser ret = RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newDelimited(delim.getDelegate(), ReadStreamSubscriber.asReadStream(stream, obj -> obj.getDelegate()).resume()));
        return ret;
    }

    public static RecordParser newFixed(int size) {
        RecordParser ret = RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newFixed(size));
        return ret;
    }

    private static RecordParser __newFixed(int size, final Handler<Buffer> output) {
        RecordParser ret = RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newFixed(size, new Handler<io.vertx.core.buffer.Buffer>(){

            @Override
            public void handle(io.vertx.core.buffer.Buffer event) {
                output.handle(Buffer.newInstance(event));
            }
        }));
        return ret;
    }

    public static RecordParser newFixed(int size, Consumer<Buffer> output) {
        return RecordParser.__newFixed(size, output != null ? output::accept : null);
    }

    public static RecordParser newFixed(int size, ReadStream<Buffer> stream) {
        RecordParser ret = RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newFixed(size, stream.getDelegate()));
        return ret;
    }

    public static RecordParser newFixed(int size, Publisher<Buffer> stream) {
        RecordParser ret = RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newFixed(size, ReadStreamSubscriber.asReadStream(stream, obj -> obj.getDelegate()).resume()));
        return ret;
    }

    public void delimitedMode(String delim) {
        this.delegate.delimitedMode(delim);
    }

    public void delimitedMode(Buffer delim) {
        this.delegate.delimitedMode(delim.getDelegate());
    }

    public void fixedSizeMode(int size) {
        this.delegate.fixedSizeMode(size);
    }

    public RecordParser maxRecordSize(int size) {
        this.delegate.maxRecordSize(size);
        return this;
    }

    @Override
    public void handle(Buffer buffer) {
        this.delegate.handle(buffer.getDelegate());
    }

    private RecordParser __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler((Handler)handler);
        return this;
    }

    @Override
    public RecordParser exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler(handler != null ? handler::accept : null);
    }

    private RecordParser __handler(final Handler<Buffer> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.core.buffer.Buffer>(){

            @Override
            public void handle(io.vertx.core.buffer.Buffer event) {
                handler.handle(Buffer.newInstance(event));
            }
        });
        return this;
    }

    public RecordParser handler(Consumer<Buffer> handler) {
        return this.__handler(handler != null ? handler::accept : null);
    }

    public RecordParser pause() {
        this.delegate.pause();
        return this;
    }

    public RecordParser fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    public RecordParser resume() {
        this.delegate.resume();
        return this;
    }

    private RecordParser __endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler((Handler)endHandler);
        return this;
    }

    public RecordParser endHandler(Consumer<Void> endHandler) {
        return this.__endHandler(endHandler != null ? endHandler::accept : null);
    }

    public void pipeToAndForget(WriteStream<Buffer> dst) {
        this.delegate.pipeTo(dst.getDelegate());
    }

    @Override
    public synchronized Multi<Buffer> toMulti() {
        if (this.multi == null) {
            Function<io.vertx.core.buffer.Buffer, Buffer> conv = Buffer::newInstance;
            this.multi = MultiHelper.toMulti(this.delegate, conv);
        }
        return this.multi;
    }

    public Iterable<Buffer> toBlockingIterable() {
        return this.toMulti().subscribe().asIterable();
    }

    public Stream<Buffer> toBlockingStream() {
        return this.toMulti().subscribe().asStream();
    }

    public static RecordParser newInstance(io.vertx.core.parsetools.RecordParser arg) {
        return arg != null ? new RecordParser(arg) : null;
    }
}

