/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class UniProduceMultiOnItem<I, O>
extends AbstractMulti<O> {
    private final Function<? super I, ? extends Publisher<? extends O>> mapper;
    private final Uni<I> upstream;

    public UniProduceMultiOnItem(Uni<I> upstream, Function<? super I, ? extends Publisher<? extends O>> mapper) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
        this.mapper = ParameterValidation.nonNull(mapper, "mapper");
    }

    @Override
    public void subscribe(MultiSubscriber<? super O> subscriber) {
        if (subscriber == null) {
            throw new NullPointerException("The subscriber must not be `null`");
        }
        this.upstream.subscribe().withSubscriber(new FlatMapPublisherSubscriber<I, O>(subscriber, this.mapper));
    }

    static final class FlatMapPublisherSubscriber<I, O>
    implements Subscriber<O>,
    UniSubscriber<I>,
    Subscription {
        private AtomicReference<Subscription> secondUpstream;
        private AtomicReference<UniSubscription> firstUpstream;
        private final Subscriber<? super O> downstream;
        private final Function<? super I, ? extends Publisher<? extends O>> mapper;
        private final AtomicLong requested = new AtomicLong();

        FlatMapPublisherSubscriber(Subscriber<? super O> downstream, Function<? super I, ? extends Publisher<? extends O>> mapper) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.firstUpstream = new AtomicReference();
            this.secondUpstream = new AtomicReference();
        }

        @Override
        public void onNext(O item) {
            this.downstream.onNext(item);
        }

        @Override
        public void onError(Throwable failure) {
            this.downstream.onError(failure);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void request(long n) {
            Subscriptions.requestIfNotNullOrAccumulate(this.secondUpstream, this.requested, n);
        }

        @Override
        public void cancel() {
            UniSubscription subscription = this.firstUpstream.getAndSet(EmptyUniSubscription.CANCELLED);
            if (subscription != null && subscription != EmptyUniSubscription.CANCELLED) {
                subscription.cancel();
            }
            Subscriptions.cancel(this.secondUpstream);
        }

        @Override
        public void onSubscribe(UniSubscription subscription) {
            if (this.firstUpstream.compareAndSet(null, subscription)) {
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            long r;
            if (this.secondUpstream.compareAndSet(null, subscription) && (r = this.requested.getAndSet(0L)) != 0L) {
                subscription.request(r);
            }
        }

        @Override
        public void onItem(I item) {
            Publisher<O> publisher;
            try {
                publisher = this.mapper.apply(item);
                if (publisher == null) {
                    throw new NullPointerException("The mapper returned `null`");
                }
            }
            catch (Throwable ex) {
                this.downstream.onError(ex);
                return;
            }
            publisher.subscribe(this);
        }

        @Override
        public void onFailure(Throwable failure) {
            this.downstream.onError(failure);
        }
    }
}

