/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.impl;

import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.vertx.core.AsyncResult;
import io.vertx.core.streams.WriteStream;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Subscription;

public class WriteStreamSubscriberImpl<R, T>
implements WriteStreamSubscriber<R> {
    private static final int BATCH_SIZE = 16;
    private final WriteStream<T> writeStream;
    private final Function<R, T> mapping;
    private Subscription subscription;
    private int outstanding;
    private boolean done;
    private Consumer<? super Throwable> flowableErrorHandler;
    private Action flowableCompleteHandler;
    private Consumer<? super Throwable> writeStreamExceptionHandler;
    private Action writeStreamEndHandler;
    private Consumer<? super Throwable> writeStreamEndErrorHandler;

    public WriteStreamSubscriberImpl(WriteStream<T> writeStream, Function<R, T> mapping) {
        Objects.requireNonNull(writeStream, "writeStream");
        Objects.requireNonNull(mapping, "mapping");
        this.writeStream = writeStream;
        this.mapping = mapping;
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        Objects.requireNonNull(subscription, "subscription");
        if (!this.setSubscription(subscription)) {
            subscription.cancel();
            SubscriptionHelper.reportSubscriptionSet();
            return;
        }
        this.writeStream.exceptionHandler(t -> {
            Consumer<? super Throwable> c;
            if (!this.setDone()) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.getSubscription().cancel();
            WriteStreamSubscriberImpl writeStreamSubscriberImpl = this;
            synchronized (writeStreamSubscriberImpl) {
                c = this.writeStreamExceptionHandler;
            }
            if (c != null) {
                try {
                    c.accept((Throwable)t);
                }
                catch (Exception e) {
                    RxJavaPlugins.onError(e);
                }
            }
        });
        this.writeStream.drainHandler(v -> this.requestMore());
        this.requestMore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(R r) {
        if (this.isDone()) {
            return;
        }
        if (r == null) {
            RuntimeException throwable = new NullPointerException("onNext called with null");
            try {
                this.getSubscription().cancel();
            }
            catch (Throwable t) {
                Exceptions.throwIfFatal(t);
                throwable = new CompositeException(throwable, t);
            }
            this.onError(throwable);
            return;
        }
        try {
            this.writeStream.write(this.mapping.apply(r));
            WriteStreamSubscriberImpl throwable = this;
            synchronized (throwable) {
                --this.outstanding;
            }
        }
        catch (Throwable t) {
            Throwable throwable;
            Exceptions.throwIfFatal(t);
            try {
                this.getSubscription().cancel();
                throwable = t;
            }
            catch (Throwable t1) {
                Exceptions.throwIfFatal(t1);
                throwable = new CompositeException(t, t1);
            }
            this.onError(throwable);
            return;
        }
        if (!this.writeStream.writeQueueFull()) {
            this.requestMore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable t) {
        Consumer<? super Throwable> c;
        if (!this.setDone()) {
            RxJavaPlugins.onError(t);
            return;
        }
        Objects.requireNonNull(t, "onError called with null");
        WriteStreamSubscriberImpl writeStreamSubscriberImpl = this;
        synchronized (writeStreamSubscriberImpl) {
            c = this.flowableErrorHandler;
        }
        try {
            if (c != null) {
                c.accept(t);
            }
        }
        catch (Throwable t1) {
            Exceptions.throwIfFatal(t1);
            RxJavaPlugins.onError(t1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        Action a;
        if (!this.setDone()) {
            return;
        }
        WriteStreamSubscriberImpl writeStreamSubscriberImpl = this;
        synchronized (writeStreamSubscriberImpl) {
            a = this.flowableCompleteHandler;
        }
        try {
            this.writeStream.end(this::writeStreamEnd);
            if (a != null) {
                a.run();
            }
        }
        catch (Throwable t) {
            Exceptions.throwIfFatal(t);
            RxJavaPlugins.onError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStreamEnd(AsyncResult<Void> result) {
        block11: {
            try {
                Consumer<? super Throwable> c;
                if (result.succeeded()) {
                    Action a;
                    WriteStreamSubscriberImpl writeStreamSubscriberImpl = this;
                    synchronized (writeStreamSubscriberImpl) {
                        a = this.writeStreamEndHandler;
                    }
                    if (a != null) {
                        a.run();
                    }
                    break block11;
                }
                WriteStreamSubscriberImpl writeStreamSubscriberImpl = this;
                synchronized (writeStreamSubscriberImpl) {
                    c = this.writeStreamEndErrorHandler;
                }
                if (c != null) {
                    c.accept(result.cause());
                }
            }
            catch (Throwable t) {
                Exceptions.throwIfFatal(t);
                RxJavaPlugins.onError(t);
            }
        }
    }

    private synchronized Subscription getSubscription() {
        return this.subscription;
    }

    private synchronized boolean setSubscription(Subscription subscription) {
        if (this.subscription == null) {
            this.subscription = subscription;
            return true;
        }
        return false;
    }

    private synchronized boolean isDone() {
        return this.done;
    }

    private synchronized boolean setDone() {
        return this.done ? false : (this.done = true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestMore() {
        Subscription s = this.getSubscription();
        if (s == null) {
            return;
        }
        WriteStreamSubscriberImpl writeStreamSubscriberImpl = this;
        synchronized (writeStreamSubscriberImpl) {
            if (this.done || this.outstanding > 0) {
                return;
            }
            this.outstanding = 16;
        }
        s.request(16L);
    }

    @Override
    public synchronized WriteStreamSubscriber<R> onError(Consumer<? super Throwable> handler) {
        this.flowableErrorHandler = handler;
        return this;
    }

    @Override
    public synchronized WriteStreamSubscriber<R> onComplete(Action handler) {
        this.flowableCompleteHandler = handler;
        return this;
    }

    @Override
    public synchronized WriteStreamSubscriber<R> onWriteStreamError(Consumer<? super Throwable> handler) {
        this.writeStreamExceptionHandler = handler;
        return this;
    }

    @Override
    public synchronized WriteStreamSubscriber<R> onWriteStreamEnd(Action handler) {
        this.writeStreamEndHandler = handler;
        return this;
    }

    @Override
    public synchronized WriteStreamSubscriber<R> onWriteStreamEndError(Consumer<? super Throwable> handler) {
        this.writeStreamEndErrorHandler = handler;
        return this;
    }
}

