/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.mgmt;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.StaticHandler;
import java.nio.charset.StandardCharsets;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class VertxRouter {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxRouter.class);
    @Inject
    @ConfigProperty(name="kogito.dataindex.http.url", defaultValue="http://localhost:8180")
    String dataIndexHttpURL;
    @Inject
    @ConfigProperty(name="kogito.auth.enabled", defaultValue="false")
    String authEnabled;
    @Inject
    @ConfigProperty(name="kogito.auth.keycloak.realm", defaultValue="kogito")
    String authKeycloakRealm;
    @Inject
    @ConfigProperty(name="kogito.auth.keycloak.url", defaultValue="http://localhost:8280")
    String authKeycloakUrl;
    @Inject
    @ConfigProperty(name="kogito.auth.keycloak.client.id", defaultValue="kogito-console-quarkus")
    String authKeycloakClientId;
    @Inject
    Vertx vertx;
    private String resource;

    @PostConstruct
    public void init() {
        this.resource = this.vertx.fileSystem().readFileBlocking("META-INF/resources/index.html").toString(StandardCharsets.UTF_8).replace("__DATA_INDEX_ENDPOINT__", "\"" + this.dataIndexHttpURL + "/graphql\"").replace("__KOGITO_AUTH_ENABLED__", this.authEnabled).replace("__KOGITO_AUTH_KEYCLOAK_REALM__", "\"" + this.authKeycloakRealm + "\"").replace("__KOGITO_AUTH_KEYCLOAK_URL__", "\"" + this.authKeycloakUrl + "\"").replace("__KOGITO_AUTH_KEYCLOAK_CLIENT_ID__", "\"" + this.authKeycloakClientId + "\"");
    }

    void setupRouter(@Observes Router router) {
        router.route("/").handler(ctx -> ctx.response().putHeader("location", "/ProcessInstances/").setStatusCode(302).end());
        router.route("/Process*").handler(ctx -> this.handle((RoutingContext)ctx));
        router.route("/DomainExplorer*").handler(ctx -> this.handle((RoutingContext)ctx));
        router.route().handler((Handler)StaticHandler.create());
    }

    public void handle(RoutingContext context) {
        try {
            context.response().putHeader(HttpHeaders.CACHE_CONTROL, (CharSequence)"no-cache").putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html;charset=utf8").end(this.resource);
        }
        catch (Exception ex) {
            LOGGER.error("Error handling index.html", (Throwable)ex);
            context.fail(500, (Throwable)ex);
        }
    }
}

