/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime;

import io.quarkus.resteasy.runtime.NonJaxRsClassMappings;
import io.quarkus.runtime.TemplateHtmlBuilder;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Priority;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.jboss.logging.Logger;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.core.request.ServerDrivenNegotiation;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResourceInvoker;

@Provider
@Priority(value=5001)
public class NotFoundExceptionMapper
implements ExceptionMapper<NotFoundException> {
    protected static final String META_INF_RESOURCES_SLASH = "META-INF/resources/";
    protected static final String META_INF_RESOURCES = "META-INF/resources";
    private static final Variant JSON_VARIANT = new Variant(MediaType.APPLICATION_JSON_TYPE, (String)null, null);
    private static final Variant HTML_VARIANT = new Variant(MediaType.TEXT_HTML_TYPE, (String)null, null);
    private static final List<Variant> VARIANTS = Arrays.asList(JSON_VARIANT, HTML_VARIANT);
    private static volatile String httpRoot = "";
    private static volatile List<String> servletMappings = Collections.EMPTY_LIST;
    private static volatile Set<java.nio.file.Path> staticResouceRoots = Collections.EMPTY_SET;
    private static volatile List<String> additionalEndpoints = Collections.EMPTY_LIST;
    private static volatile Map<String, NonJaxRsClassMappings> nonJaxRsClassNameToMethodPaths = Collections.EMPTY_MAP;
    private static final Logger LOG = Logger.getLogger(NotFoundExceptionMapper.class);
    @Context
    private Registry registry = null;
    @Context
    private HttpHeaders headers;

    public static void setHttpRoot(String rootPath) {
        httpRoot = rootPath;
    }

    @Override
    public Response toResponse(NotFoundException exception) {
        if (this.registry == null) {
            return this.respond();
        }
        Map bounded = null;
        if (this.registry instanceof ResourceMethodRegistry) {
            bounded = ((ResourceMethodRegistry)this.registry).getBounded();
        } else if (Proxy.isProxyClass(this.registry.getClass()) && this.registry.toString().startsWith(ResourceMethodRegistry.class.getName())) {
            try {
                bounded = (Map)Proxy.getInvocationHandler(this.registry).invoke(this.registry, ResourceMethodRegistry.class.getMethod("getBounded", new Class[0]), new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (bounded == null) {
            return this.respond();
        }
        List<ResourceDescription> descriptions = ResourceDescription.fromBoundResourceInvokers(bounded.entrySet());
        return this.respond(descriptions);
    }

    private Response respond() {
        Variant variant = NotFoundExceptionMapper.selectVariant(this.headers);
        if (variant == JSON_VARIANT) {
            return Response.status(Response.Status.NOT_FOUND).type("application/json").build();
        }
        if (variant == HTML_VARIANT) {
            TemplateHtmlBuilder sb = new TemplateHtmlBuilder("404 - Resource Not Found", "", "No resources discovered");
            return Response.status(Response.Status.NOT_FOUND).entity(sb.toString()).type(MediaType.TEXT_HTML_TYPE).build();
        }
        return Response.status(Response.Status.NOT_FOUND).build();
    }

    private Response respond(List<ResourceDescription> descriptions) {
        Variant variant = NotFoundExceptionMapper.selectVariant(this.headers);
        if (variant == JSON_VARIANT) {
            return Response.status(Response.Status.NOT_FOUND).type("application/json").build();
        }
        if (variant == HTML_VARIANT) {
            List<String> resources;
            TemplateHtmlBuilder sb = new TemplateHtmlBuilder("404 - Resource Not Found", "", "Resources overview");
            sb.resourcesStart("REST resources");
            for (ResourceDescription resourceDescription : descriptions) {
                sb.resourcePath(this.adjustRoot(resourceDescription.basePath));
                for (MethodDescription method : resourceDescription.calls) {
                    sb.method(method.method, method.fullPath);
                    if (method.consumes != null) {
                        sb.consumes(method.consumes);
                    }
                    if (method.produces != null) {
                        sb.produces(method.produces);
                    }
                    sb.methodEnd();
                }
                sb.resourceEnd();
            }
            if (descriptions.isEmpty()) {
                sb.noResourcesFound();
            }
            sb.resourcesEnd();
            if (!servletMappings.isEmpty()) {
                sb.resourcesStart("Servlet mappings");
                for (String string : servletMappings) {
                    sb.servletMapping(this.adjustRoot(string));
                }
                sb.resourcesEnd();
            }
            if (!staticResouceRoots.isEmpty() && !(resources = this.findRealResources()).isEmpty()) {
                sb.resourcesStart("Static resources");
                for (String staticResource : resources) {
                    sb.staticResourcePath(this.adjustRoot(staticResource));
                }
                sb.resourcesEnd();
            }
            if (!additionalEndpoints.isEmpty()) {
                sb.resourcesStart("Additional endpoints");
                for (String string : additionalEndpoints) {
                    sb.staticResourcePath(this.adjustRoot(string));
                }
                sb.resourcesEnd();
            }
            return Response.status(Response.Status.NOT_FOUND).entity(sb.toString()).type(MediaType.TEXT_HTML_TYPE).build();
        }
        return Response.status(Response.Status.NOT_FOUND).build();
    }

    private List<String> findRealResources() {
        final HashSet<String> knownFiles = new HashSet<String>();
        for (final java.nio.file.Path resource : staticResouceRoots) {
            if (resource == null || !Files.exists(resource, new LinkOption[0])) continue;
            try {
                Stream<java.nio.file.Path> fileTreeElements = Files.walk(resource, new FileVisitOption[0]);
                Throwable throwable = null;
                try {
                    fileTreeElements.forEach(new Consumer<java.nio.file.Path>(){

                        @Override
                        public void accept(java.nio.file.Path path) {
                            if (resource.equals(path)) {
                                return;
                            }
                            java.nio.file.Path rel = resource.relativize(path);
                            if (!Files.isDirectory(path, new LinkOption[0])) {
                                knownFiles.add(rel.toString());
                            }
                        }
                    });
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fileTreeElements == null) continue;
                    if (throwable != null) {
                        try {
                            fileTreeElements.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fileTreeElements.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to read static resources", e);
            }
        }
        try {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(META_INF_RESOURCES);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                if (!url.getProtocol().equals("jar")) continue;
                JarURLConnection jar = (JarURLConnection)url.openConnection();
                jar.setUseCaches(false);
                JarFile jarFile = jar.getJarFile();
                Throwable throwable = null;
                try {
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        String sub;
                        JarEntry entry = entries.nextElement();
                        if (!entry.getName().startsWith(META_INF_RESOURCES_SLASH) || (sub = entry.getName().substring(META_INF_RESOURCES_SLASH.length())).isEmpty() || entry.getName().endsWith("/")) continue;
                        knownFiles.add(sub);
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (jarFile == null) continue;
                    if (throwable != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    jarFile.close();
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to read static resources", e);
        }
        return knownFiles.stream().filter(this::isHtmlFileName).limit(1000L).distinct().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
    }

    private boolean isHtmlFileName(String fileName) {
        return fileName.endsWith(".html") || fileName.endsWith(".htm");
    }

    private String adjustRoot(String basePath) {
        if (httpRoot.equals("/")) {
            return basePath;
        }
        if (basePath.startsWith("/")) {
            if (!httpRoot.endsWith("/")) {
                return httpRoot + basePath;
            }
            return httpRoot.substring(0, httpRoot.length() - 1) + basePath;
        }
        if (httpRoot.endsWith("/")) {
            return httpRoot.substring(1) + basePath;
        }
        return httpRoot.substring(1) + "/" + basePath;
    }

    private static Variant selectVariant(HttpHeaders headers) {
        ServerDrivenNegotiation negotiation = new ServerDrivenNegotiation();
        negotiation.setAcceptHeaders((List)headers.getRequestHeaders().get("Accept"));
        return negotiation.getBestMatch(VARIANTS);
    }

    public static void servlets(Map<String, List<String>> servletToMapping) {
        servletMappings = servletToMapping.values().stream().flatMap(Collection::stream).sorted().collect(Collectors.toList());
    }

    public static void staticResources(Set<String> knownRoots) {
        staticResouceRoots = new HashSet<java.nio.file.Path>();
        for (String i : knownRoots) {
            staticResouceRoots.add(Paths.get(i, new String[0]));
        }
    }

    public static void nonJaxRsClassNameToMethodPaths(Map<String, NonJaxRsClassMappings> nonJaxRsPaths) {
        nonJaxRsClassNameToMethodPaths = nonJaxRsPaths;
    }

    public static void setAdditionalEndpoints(List<String> additionalEndpoints) {
        NotFoundExceptionMapper.additionalEndpoints = additionalEndpoints;
    }

    public static final class ResourceDescription {
        public final String basePath;
        public final List<MethodDescription> calls;

        public ResourceDescription(String basePath) {
            this.basePath = basePath;
            this.calls = new ArrayList<MethodDescription>();
        }

        public void addMethod(String path, ResourceMethodInvoker method) {
            String produces = ResourceDescription.mostPreferredOrNull(method.getProduces());
            String consumes = ResourceDescription.mostPreferredOrNull(method.getConsumes());
            for (String verb : method.getHttpMethods()) {
                this.calls.add(new MethodDescription(verb, path, produces, consumes));
            }
        }

        private static String mostPreferredOrNull(MediaType[] mediaTypes) {
            if (mediaTypes == null || mediaTypes.length < 1) {
                return null;
            }
            return mediaTypes[0].toString();
        }

        public static List<ResourceDescription> fromBoundResourceInvokers(Set<Map.Entry<String, List<ResourceInvoker>>> bound) {
            HashMap<String, ResourceDescription> descriptions = new HashMap<String, ResourceDescription>();
            for (Map.Entry<String, List<ResourceInvoker>> entry : bound) {
                for (ResourceInvoker invoker : entry.getValue()) {
                    if (!(invoker instanceof ResourceMethodInvoker)) continue;
                    ResourceMethodInvoker method = (ResourceMethodInvoker)invoker;
                    Class<?> resourceClass = method.getResourceClass();
                    String resourceClassName = resourceClass.getName();
                    String basePath = null;
                    NonJaxRsClassMappings nonJaxRsClassMappings = null;
                    Path path = resourceClass.getAnnotation(Path.class);
                    if (path == null) {
                        nonJaxRsClassMappings = (NonJaxRsClassMappings)nonJaxRsClassNameToMethodPaths.get(resourceClassName);
                        if (nonJaxRsClassMappings != null) {
                            basePath = nonJaxRsClassMappings.getBasePath();
                        }
                    } else {
                        basePath = path.value();
                    }
                    if (basePath == null) continue;
                    if (!descriptions.containsKey(basePath)) {
                        descriptions.put(basePath, new ResourceDescription(basePath));
                    }
                    String subPath = "";
                    for (Annotation annotation : method.getMethodAnnotations()) {
                        if (!annotation.annotationType().equals(Path.class)) continue;
                        subPath = ((Path)annotation).value();
                        break;
                    }
                    if (subPath.isEmpty() && nonJaxRsClassMappings != null) {
                        String methodName = method.getMethod().getName();
                        String subPathFromMethodName = nonJaxRsClassMappings.getMethodNameToPath().get(methodName);
                        if (subPathFromMethodName != null) {
                            subPath = subPathFromMethodName;
                        }
                    }
                    ((ResourceDescription)descriptions.get(basePath)).addMethod(basePath + subPath, method);
                }
            }
            return new LinkedList<ResourceDescription>(descriptions.values());
        }
    }

    public static final class MethodDescription {
        public String method;
        public String fullPath;
        public String produces;
        public String consumes;

        public MethodDescription(String method, String fullPath, String produces, String consumes) {
            this.method = method;
            this.fullPath = fullPath;
            this.produces = produces;
            this.consumes = consumes;
        }
    }
}

