/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.context.runtime;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.smallrye.context.runtime.SmallRyeContextPropagationProvider;
import io.smallrye.context.SmallRyeContextManager;
import io.smallrye.context.SmallRyeContextManagerProvider;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.eclipse.microprofile.context.spi.ContextManagerExtension;
import org.eclipse.microprofile.context.spi.ContextManagerProvider;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;

@Recorder
public class SmallRyeContextPropagationRecorder {
    private static SmallRyeContextManager.Builder builder;

    public void configureStaticInit(List<ThreadContextProvider> discoveredProviders, List<ContextManagerExtension> discoveredExtensions) {
        if (ContextManagerProvider.INSTANCE.get() == null) {
            SmallRyeContextManagerProvider contextManagerProvider = new SmallRyeContextManagerProvider();
            ContextManagerProvider.register(contextManagerProvider);
        }
        builder = (SmallRyeContextManager.Builder)ContextManagerProvider.instance().getContextManagerBuilder();
        builder.withThreadContextProviders(discoveredProviders.toArray(new ThreadContextProvider[0]));
        builder.withContextManagerExtensions(discoveredExtensions.toArray(new ContextManagerExtension[0]));
    }

    public void configureRuntime(BeanContainer container, ExecutorService executorService) {
        ContextManagerProvider contextManagerProvider = ContextManagerProvider.instance();
        builder.withDefaultExecutorService(executorService);
        SmallRyeContextManager contextManager = builder.build();
        contextManagerProvider.registerContextManager(contextManager, Thread.currentThread().getContextClassLoader());
        SmallRyeContextPropagationProvider cpProvider = container.instance(SmallRyeContextPropagationProvider.class, new Annotation[0]);
        cpProvider.initialize(executorService);
    }
}

