/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiRetryOp;
import java.util.function.Predicate;

public class MultiRetry<T> {
    private final Multi<T> upstream;

    public MultiRetry(Multi<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Multi<T> indefinitely() {
        return this.atMost(Long.MAX_VALUE);
    }

    public Multi<T> atMost(long numberOfAttempts) {
        return Infrastructure.onMultiCreation(new MultiRetryOp<T>(this.upstream, numberOfAttempts));
    }

    public Multi<T> until(Predicate<? super Throwable> predicate) {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

