/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.streams.utils;

import java.util.Objects;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class DelegatingSubscriber<O>
implements Subscriber<O> {
    private final Subscriber<? super O> delegate;

    public DelegatingSubscriber(Subscriber<? super O> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void onSubscribe(Subscription s) {
        Objects.requireNonNull(s);
        this.delegate.onSubscribe(s);
    }

    @Override
    public void onNext(O out) {
        Objects.requireNonNull(out);
        this.delegate.onNext(out);
    }

    @Override
    public void onError(Throwable t) {
        Objects.requireNonNull(t);
        this.delegate.onError(t);
    }

    @Override
    public void onComplete() {
        this.delegate.onComplete();
    }
}

