/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.axle.core.http;

import io.vertx.axle.AsyncResultCompletionStage;
import io.vertx.axle.core.http.HttpConnection;
import io.vertx.axle.core.http.HttpServerRequest;
import io.vertx.axle.core.http.ServerWebSocket;
import io.vertx.axle.core.metrics.Measured;
import io.vertx.axle.core.net.SocketAddress;
import io.vertx.axle.core.streams.ReadStream;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.axle.Gen;
import io.vertx.lang.axle.TypeArg;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;

@Gen(value=io.vertx.core.http.HttpServer.class)
public class HttpServer
implements Measured {
    public static final TypeArg<HttpServer> __TYPE_ARG = new TypeArg<HttpServer>(obj -> new HttpServer((io.vertx.core.http.HttpServer)obj), HttpServer::getDelegate);
    private final io.vertx.core.http.HttpServer delegate;
    private ReadStream<HttpServerRequest> cached_0;
    private ReadStream<ServerWebSocket> cached_1;
    private ReadStream<ServerWebSocket> cached_2;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpServer that = (HttpServer)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpServer(io.vertx.core.http.HttpServer delegate) {
        this.delegate = delegate;
    }

    HttpServer() {
        this.delegate = null;
    }

    @Override
    public io.vertx.core.http.HttpServer getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public ReadStream<HttpServerRequest> requestStream() {
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        ReadStream<HttpServerRequest> ret = ReadStream.newInstance(this.delegate.requestStream(), HttpServerRequest.__TYPE_ARG);
        this.cached_0 = ret;
        return ret;
    }

    private HttpServer __requestHandler(final Handler<HttpServerRequest> handler) {
        this.delegate.requestHandler(new Handler<io.vertx.core.http.HttpServerRequest>(){

            @Override
            public void handle(io.vertx.core.http.HttpServerRequest event) {
                handler.handle(HttpServerRequest.newInstance(event));
            }
        });
        return this;
    }

    public HttpServer requestHandler(Consumer<HttpServerRequest> handler) {
        return this.__requestHandler(handler != null ? handler::accept : null);
    }

    private HttpServer __connectionHandler(final Handler<HttpConnection> handler) {
        this.delegate.connectionHandler(new Handler<io.vertx.core.http.HttpConnection>(){

            @Override
            public void handle(io.vertx.core.http.HttpConnection event) {
                handler.handle(HttpConnection.newInstance(event));
            }
        });
        return this;
    }

    public HttpServer connectionHandler(Consumer<HttpConnection> handler) {
        return this.__connectionHandler(handler != null ? handler::accept : null);
    }

    private HttpServer __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpServer exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler(handler != null ? handler::accept : null);
    }

    @Deprecated
    public ReadStream<ServerWebSocket> websocketStream() {
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        ReadStream<ServerWebSocket> ret = ReadStream.newInstance(this.delegate.websocketStream(), ServerWebSocket.__TYPE_ARG);
        this.cached_1 = ret;
        return ret;
    }

    public ReadStream<ServerWebSocket> webSocketStream() {
        if (this.cached_2 != null) {
            return this.cached_2;
        }
        ReadStream<ServerWebSocket> ret = ReadStream.newInstance(this.delegate.webSocketStream(), ServerWebSocket.__TYPE_ARG);
        this.cached_2 = ret;
        return ret;
    }

    @Deprecated
    private HttpServer __websocketHandler(final Handler<ServerWebSocket> handler) {
        this.delegate.websocketHandler(new Handler<io.vertx.core.http.ServerWebSocket>(){

            @Override
            public void handle(io.vertx.core.http.ServerWebSocket event) {
                handler.handle(ServerWebSocket.newInstance(event));
            }
        });
        return this;
    }

    @Deprecated
    public HttpServer websocketHandler(Consumer<ServerWebSocket> handler) {
        return this.__websocketHandler(handler != null ? handler::accept : null);
    }

    private HttpServer __webSocketHandler(final Handler<ServerWebSocket> handler) {
        this.delegate.webSocketHandler(new Handler<io.vertx.core.http.ServerWebSocket>(){

            @Override
            public void handle(io.vertx.core.http.ServerWebSocket event) {
                handler.handle(ServerWebSocket.newInstance(event));
            }
        });
        return this;
    }

    public HttpServer webSocketHandler(Consumer<ServerWebSocket> handler) {
        return this.__webSocketHandler(handler != null ? handler::accept : null);
    }

    private HttpServer __listen(int port, String host, final Handler<AsyncResult<HttpServer>> listenHandler) {
        this.delegate.listen(port, host, new Handler<AsyncResult<io.vertx.core.http.HttpServer>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle(Future.succeededFuture(HttpServer.newInstance(ar.result())));
                } else {
                    listenHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public CompletionStage<HttpServer> listen(int port, String host) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__listen(port, host, (Handler<AsyncResult<HttpServer>>)handler));
    }

    private HttpServer __listen(SocketAddress address, final Handler<AsyncResult<HttpServer>> listenHandler) {
        this.delegate.listen(address.getDelegate(), new Handler<AsyncResult<io.vertx.core.http.HttpServer>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle(Future.succeededFuture(HttpServer.newInstance(ar.result())));
                } else {
                    listenHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public CompletionStage<HttpServer> listen(SocketAddress address) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__listen(address, (Handler<AsyncResult<HttpServer>>)handler));
    }

    private HttpServer __listen(int port, final Handler<AsyncResult<HttpServer>> listenHandler) {
        this.delegate.listen(port, new Handler<AsyncResult<io.vertx.core.http.HttpServer>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle(Future.succeededFuture(HttpServer.newInstance(ar.result())));
                } else {
                    listenHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public CompletionStage<HttpServer> listen(int port) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__listen(port, (Handler<AsyncResult<HttpServer>>)handler));
    }

    private HttpServer __listen(final Handler<AsyncResult<HttpServer>> listenHandler) {
        this.delegate.listen(new Handler<AsyncResult<io.vertx.core.http.HttpServer>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle(Future.succeededFuture(HttpServer.newInstance(ar.result())));
                } else {
                    listenHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public CompletionStage<HttpServer> listen() {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__listen((Handler<AsyncResult<HttpServer>>)handler));
    }

    private void __close(Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.close(completionHandler);
    }

    public CompletionStage<Void> close() {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__close((Handler<AsyncResult<Void>>)handler));
    }

    public int actualPort() {
        int ret = this.delegate.actualPort();
        return ret;
    }

    public static HttpServer newInstance(io.vertx.core.http.HttpServer arg) {
        return arg != null ? new HttpServer(arg) : null;
    }
}

