/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import java.io.Serializable;
import org.mvel2.CompileException;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.PropertyAccessor;
import org.mvel2.compiler.Accessor;
import org.mvel2.debug.DebugTools;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.AccessorOptimizer;
import org.mvel2.optimizers.OptimizationNotSupported;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.util.CompilerTools;
import org.mvel2.util.ParseTools;

public class ASTNode
implements Cloneable,
Serializable {
    public static final int LITERAL = 1;
    public static final int DEEP_PROPERTY = 2;
    public static final int OPERATOR = 4;
    public static final int IDENTIFIER = 8;
    public static final int COMPILE_IMMEDIATE = 16;
    public static final int NUMERIC = 32;
    public static final int INVERT = 64;
    public static final int ASSIGN = 128;
    public static final int COLLECTION = 256;
    public static final int THISREF = 512;
    public static final int INLINE_COLLECTION = 1024;
    public static final int BLOCK_IF = 2048;
    public static final int BLOCK_FOREACH = 4096;
    public static final int BLOCK_WITH = 8192;
    public static final int BLOCK_UNTIL = 16384;
    public static final int BLOCK_WHILE = 32768;
    public static final int BLOCK_DO = 65536;
    public static final int BLOCK_DO_UNTIL = 131072;
    public static final int BLOCK_FOR = 262144;
    public static final int OPT_SUBTR = 524288;
    public static final int FQCN = 0x100000;
    public static final int STACKLANG = 0x400000;
    public static final int DEFERRED_TYPE_RES = 0x800000;
    public static final int STRONG_TYPING = 0x1000000;
    public static final int PCTX_STORED = 0x2000000;
    public static final int ARRAY_TYPE_LITERAL = 0x4000000;
    public static final int NOJIT = 0x8000000;
    public static final int DEOP = 0x10000000;
    public static final int DISCARD = 0x20000000;
    protected int firstUnion;
    protected int endOfName;
    public int fields = 0;
    protected Class egressType;
    protected char[] expr;
    protected int start;
    protected int offset;
    protected String nameCache;
    protected Object literal;
    protected volatile transient Accessor accessor;
    protected volatile Accessor safeAccessor;
    protected int cursorPosition;
    public ASTNode nextASTNode;
    protected ParserContext pCtx;

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.accessor != null) {
            try {
                return this.accessor.getValue(ctx, thisValue, factory);
            }
            catch (ClassCastException ce) {
                return this.deop(ctx, thisValue, factory, ce);
            }
        }
        return this.optimize(ctx, thisValue, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object deop(Object ctx, Object thisValue, VariableResolverFactory factory, RuntimeException e) {
        if ((this.fields & 0x10000000) == 0) {
            this.accessor = null;
            this.fields |= 0x18000000;
            ASTNode aSTNode = this;
            synchronized (aSTNode) {
                return this.getReducedValueAccelerated(ctx, thisValue, factory);
            }
        }
        throw e;
    }

    private Object optimize(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if ((this.fields & 0x10000000) != 0) {
            this.fields ^= 0x10000000;
        }
        Object retVal = null;
        AccessorOptimizer optimizer = (this.fields & 0x8000000) != 0 || factory != null && factory.isResolveable(this.nameCache) ? OptimizerFactory.getAccessorCompiler(OptimizerFactory.SAFE_REFLECTIVE) : OptimizerFactory.getDefaultAccessorCompiler();
        ParserContext pCtx = (this.fields & 0x2000000) != 0 ? (ParserContext)this.literal : new ParserContext(new ParserConfiguration(CompilerTools.getInjectedImports(factory), null));
        try {
            pCtx.optimizationNotify();
            this.setAccessor(optimizer.optimizeAccessor(pCtx, this.expr, this.start, this.offset, ctx, thisValue, factory, true, this.egressType));
        }
        catch (OptimizationNotSupported ne) {
            optimizer = OptimizerFactory.getAccessorCompiler(OptimizerFactory.SAFE_REFLECTIVE);
            this.setAccessor(optimizer.optimizeAccessor(pCtx, this.expr, this.start, this.offset, ctx, thisValue, factory, true, null));
        }
        if (this.accessor == null) {
            return PropertyAccessor.get(this.expr, this.start, this.offset, ctx, factory, thisValue, pCtx);
        }
        if (retVal == null) {
            retVal = optimizer.getResultOptPass();
        }
        if (this.egressType == null) {
            this.egressType = optimizer.getEgressType();
        }
        return retVal;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if ((this.fields & 1) != 0) {
            return this.literal;
        }
        return PropertyAccessor.get(this.expr, this.start, this.offset, ctx, factory, thisValue, this.pCtx);
    }

    protected String getAbsoluteRootElement() {
        if ((this.fields & 0x102) != 0) {
            return new String(this.expr, this.start, this.getAbsoluteFirstPart());
        }
        return this.nameCache;
    }

    public Class getEgressType() {
        return this.egressType;
    }

    public void setEgressType(Class egressType) {
        this.egressType = egressType;
    }

    public char[] getNameAsArray() {
        return ParseTools.subArray(this.expr, this.start, this.start + this.offset);
    }

    private int getAbsoluteFirstPart() {
        if ((this.fields & 0x100) != 0) {
            if (this.firstUnion < 0 || this.endOfName < this.firstUnion) {
                return this.endOfName;
            }
            return this.firstUnion;
        }
        if ((this.fields & 2) != 0) {
            return this.firstUnion;
        }
        return -1;
    }

    public String getAbsoluteName() {
        if (this.firstUnion > this.start) {
            return new String(this.expr, this.start, this.getAbsoluteFirstPart() - this.start);
        }
        return this.getName();
    }

    public String getName() {
        if (this.nameCache != null) {
            return this.nameCache;
        }
        if (this.expr != null) {
            this.nameCache = new String(this.expr, this.start, this.offset);
            return this.nameCache;
        }
        return "";
    }

    public Object getLiteralValue() {
        return this.literal;
    }

    public void storeInLiteralRegister(Object o) {
        this.literal = o;
    }

    public void setLiteralValue(Object literal) {
        this.literal = literal;
        this.fields |= 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setName(char[] name) {
        if (ParseTools.isNumber(name, this.start, this.offset)) {
            this.literal = ParseTools.handleNumericConversion(name, this.start, this.offset);
            this.egressType = this.literal.getClass();
            if (((this.fields |= 0x29) & 0x40) == 0) return;
            try {
                this.literal = ~((Integer)this.literal).intValue();
                return;
            }
            catch (ClassCastException e) {
                throw new CompileException("bitwise (~) operator can only be applied to integers", this.expr, this.start);
            }
        }
        this.literal = new String(name, this.start, this.offset);
        int end = this.start + this.offset;
        block6: for (int i = this.start; i < end; ++i) {
            switch (name[i]) {
                case '.': {
                    if (this.firstUnion != 0) break;
                    this.firstUnion = i;
                    break;
                }
                case '(': 
                case '[': {
                    if (this.firstUnion == 0) {
                        this.firstUnion = i;
                    }
                    if (this.endOfName != 0) break;
                    this.endOfName = i;
                    if (i >= name.length || name[i + 1] != ']') break block6;
                    this.fields |= 0x4000000;
                    break block6;
                }
            }
        }
        if ((this.fields & 0x400) != 0) {
            return;
        }
        if (this.firstUnion > this.start) {
            this.fields |= 0xA;
            return;
        }
        this.fields |= 8;
    }

    public Accessor setAccessor(Accessor accessor2) {
        this.accessor = accessor2;
        return this.accessor;
    }

    public boolean isIdentifier() {
        return (this.fields & 8) != 0;
    }

    public boolean isLiteral() {
        return (this.fields & 1) != 0;
    }

    public boolean isThisVal() {
        return (this.fields & 0x200) != 0;
    }

    public boolean isOperator() {
        return (this.fields & 4) != 0;
    }

    public boolean isOperator(Integer operator) {
        return (this.fields & 4) != 0 && operator.equals(this.literal);
    }

    public Integer getOperator() {
        return -1;
    }

    protected boolean isCollection() {
        return (this.fields & 0x100) != 0;
    }

    public boolean isAssignment() {
        return (this.fields & 0x80) != 0;
    }

    public boolean isDeepProperty() {
        return (this.fields & 2) != 0;
    }

    public boolean isFQCN() {
        return (this.fields & 0x100000) != 0;
    }

    public void setAsLiteral() {
        this.fields |= 1;
    }

    public void setAsFQCNReference() {
        this.fields |= 0x100000;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(int cursorPosition) {
        this.cursorPosition = cursorPosition;
    }

    public boolean isDiscard() {
        return this.fields != -1 && (this.fields & 0x20000000) != 0;
    }

    public void discard() {
        this.fields |= 0x20000000;
    }

    public void strongTyping() {
        this.fields |= 0x1000000;
    }

    public void storePctx() {
        this.fields |= 0x2000000;
    }

    public boolean isDebuggingSymbol() {
        return this.fields == -1;
    }

    public int getFields() {
        return this.fields;
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public boolean canSerializeAccessor() {
        return this.safeAccessor != null;
    }

    public int getStart() {
        return this.start;
    }

    public int getOffset() {
        return this.offset;
    }

    public char[] getExpr() {
        return this.expr;
    }

    protected ASTNode(ParserContext pCtx) {
        this.pCtx = pCtx;
    }

    public ASTNode(char[] expr, int start, int offset, int fields, ParserContext pCtx) {
        this(pCtx);
        this.fields = fields;
        this.expr = expr;
        this.start = start;
        this.offset = offset;
        this.setName(expr);
    }

    public String toString() {
        return this.isOperator() ? "<<" + DebugTools.getOperatorName(this.getOperator()) + ">>" : ((0x2000000 & this.fields) != 0 ? this.nameCache : new String(this.expr, this.start, this.offset));
    }

    protected ClassLoader getClassLoader() {
        return this.pCtx != null ? this.pCtx.getClassLoader() : Thread.currentThread().getContextClassLoader();
    }
}

