/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigValue;
import io.smallrye.config.ConfigValueConfigSource;
import io.smallrye.config.ConfigValueMapStringView;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

final class ConfigValueConfigSourceWrapper
implements ConfigValueConfigSource,
Serializable {
    private static final long serialVersionUID = -1109094614437147326L;
    private final ConfigSource configSource;

    private ConfigValueConfigSourceWrapper(ConfigSource configSource) {
        this.configSource = configSource;
    }

    @Override
    public ConfigValue getConfigValue(String propertyName) {
        String value = this.configSource.getValue(propertyName);
        if (value != null) {
            return ConfigValue.builder().withName(propertyName).withValue(value).withConfigSourceName(this.getName()).withConfigSourceOrdinal(this.getOrdinal()).build();
        }
        return null;
    }

    @Override
    public Map<String, ConfigValue> getConfigValueProperties() {
        return new ConfigValueMapStringView(this.configSource.getProperties(), this.configSource.getName(), this.configSource.getOrdinal());
    }

    @Override
    public Map<String, String> getProperties() {
        return this.configSource.getProperties();
    }

    @Override
    public String getValue(String propertyName) {
        return this.configSource.getValue(propertyName);
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.configSource.getPropertyNames();
    }

    @Override
    public String getName() {
        return this.configSource.getName();
    }

    @Override
    public int getOrdinal() {
        return this.configSource.getOrdinal();
    }

    ConfigSource unwrap() {
        return this.configSource;
    }

    static ConfigValueConfigSource wrap(ConfigSource configSource) {
        if (configSource instanceof ConfigValueConfigSource) {
            return (ConfigValueConfigSource)configSource;
        }
        return new ConfigValueConfigSourceWrapper(configSource);
    }
}

