/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.spies;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniOnFailure;
import io.smallrye.mutiny.helpers.spies.UniSpyBase;
import io.smallrye.mutiny.operators.UniSerializedSubscriber;
import java.util.function.Predicate;

public class UniOnFailureSpy<T>
extends UniSpyBase<T> {
    private Predicate<? super Throwable> predicate;
    private Class<? extends Throwable> typeOfFailure;
    private volatile Throwable lastFailure;

    public Throwable lastFailure() {
        return this.lastFailure;
    }

    @Override
    public void reset() {
        super.reset();
        this.lastFailure = null;
    }

    UniOnFailureSpy(Uni<T> upstream) {
        super(upstream);
    }

    UniOnFailureSpy(Uni<T> upstream, Predicate<? super Throwable> predicate) {
        super(upstream);
        this.predicate = predicate;
    }

    UniOnFailureSpy(Uni<T> upstream, Class<? extends Throwable> typeOfFailure) {
        super(upstream);
        this.typeOfFailure = typeOfFailure;
    }

    @Override
    protected void subscribing(UniSerializedSubscriber<? super T> downstream) {
        UniOnFailure group = this.predicate != null ? this.upstream().onFailure(this.predicate) : (this.typeOfFailure != null ? this.upstream().onFailure(this.typeOfFailure) : this.upstream().onFailure());
        group.invoke((Throwable failure) -> {
            this.incrementInvocationCount();
            this.lastFailure = failure;
        }).subscribe().withSubscriber(downstream);
    }

    @Override
    public String toString() {
        return "UniOnFailureSpy{lastFailure=" + this.lastFailure + "} " + super.toString();
    }
}

