/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.spies;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.operators.UniOperator;
import java.util.concurrent.atomic.AtomicLong;

abstract class UniSpyBase<T>
extends UniOperator<T, T> {
    private AtomicLong invocationCount = new AtomicLong();

    protected void incrementInvocationCount() {
        this.invocationCount.incrementAndGet();
    }

    public long invocationCount() {
        return this.invocationCount.get();
    }

    public boolean invoked() {
        return this.invocationCount() > 0L;
    }

    UniSpyBase(Uni<T> upstream) {
        super(upstream);
    }

    public void reset() {
        this.invocationCount.set(0L);
    }

    public String toString() {
        return "UniSpyBase{invocationCount=" + this.invocationCount + "}";
    }
}

