/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.DefaultUniEmitter;
import io.smallrye.mutiny.operators.UniSerializedSubscriber;
import io.smallrye.mutiny.subscription.UniEmitter;
import java.util.function.Consumer;

public class UniCreateWithEmitter<T>
extends AbstractUni<T> {
    private final Consumer<UniEmitter<? super T>> consumer;

    public UniCreateWithEmitter(Consumer<UniEmitter<? super T>> consumer) {
        this.consumer = ParameterValidation.nonNull(consumer, "consumer");
    }

    @Override
    protected void subscribing(UniSerializedSubscriber<? super T> subscriber) {
        DefaultUniEmitter<T> emitter = new DefaultUniEmitter<T>(subscriber);
        subscriber.onSubscribe(emitter);
        try {
            this.consumer.accept(emitter);
        }
        catch (RuntimeException e) {
            emitter.fail(e);
        }
    }
}

