/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.axle.core.file;

import io.vertx.axle.AsyncResultCompletionStage;
import io.vertx.axle.core.file.AsyncFile;
import io.vertx.axle.core.file.FileProps;
import io.vertx.axle.core.file.FileSystemProps;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.CopyOptions;
import io.vertx.core.file.OpenOptions;
import io.vertx.lang.axle.Gen;
import io.vertx.lang.axle.TypeArg;
import java.util.List;
import java.util.concurrent.CompletionStage;

@Gen(value=io.vertx.core.file.FileSystem.class)
public class FileSystem {
    public static final TypeArg<FileSystem> __TYPE_ARG = new TypeArg<FileSystem>(obj -> new FileSystem((io.vertx.core.file.FileSystem)obj), FileSystem::getDelegate);
    private final io.vertx.core.file.FileSystem delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSystem that = (FileSystem)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public FileSystem(io.vertx.core.file.FileSystem delegate) {
        this.delegate = delegate;
    }

    FileSystem() {
        this.delegate = null;
    }

    public io.vertx.core.file.FileSystem getDelegate() {
        return this.delegate;
    }

    private FileSystem __copy(String from, String to, Handler<AsyncResult<Void>> handler) {
        this.delegate.copy(from, to, handler);
        return this;
    }

    public CompletionStage<Void> copy(String from, String to) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__copy(from, to, (Handler<AsyncResult<Void>>)handler));
    }

    private FileSystem __copy(String from, String to, CopyOptions options, Handler<AsyncResult<Void>> handler) {
        this.delegate.copy(from, to, options, handler);
        return this;
    }

    public CompletionStage<Void> copy(String from, String to, CopyOptions options) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__copy(from, to, options, (Handler<AsyncResult<Void>>)handler));
    }

    public FileSystem copyBlocking(String from, String to) {
        this.delegate.copyBlocking(from, to);
        return this;
    }

    private FileSystem __copyRecursive(String from, String to, boolean recursive, Handler<AsyncResult<Void>> handler) {
        this.delegate.copyRecursive(from, to, recursive, handler);
        return this;
    }

    public CompletionStage<Void> copyRecursive(String from, String to, boolean recursive) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__copyRecursive(from, to, recursive, (Handler<AsyncResult<Void>>)handler));
    }

    public FileSystem copyRecursiveBlocking(String from, String to, boolean recursive) {
        this.delegate.copyRecursiveBlocking(from, to, recursive);
        return this;
    }

    private FileSystem __move(String from, String to, Handler<AsyncResult<Void>> handler) {
        this.delegate.move(from, to, handler);
        return this;
    }

    public CompletionStage<Void> move(String from, String to) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__move(from, to, (Handler<AsyncResult<Void>>)handler));
    }

    private FileSystem __move(String from, String to, CopyOptions options, Handler<AsyncResult<Void>> handler) {
        this.delegate.move(from, to, options, handler);
        return this;
    }

    public CompletionStage<Void> move(String from, String to, CopyOptions options) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__move(from, to, options, (Handler<AsyncResult<Void>>)handler));
    }

    public FileSystem moveBlocking(String from, String to) {
        this.delegate.moveBlocking(from, to);
        return this;
    }

    private FileSystem __truncate(String path, long len, Handler<AsyncResult<Void>> handler) {
        this.delegate.truncate(path, len, handler);
        return this;
    }

    public CompletionStage<Void> truncate(String path, long len) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__truncate(path, len, (Handler<AsyncResult<Void>>)handler));
    }

    public FileSystem truncateBlocking(String path, long len) {
        this.delegate.truncateBlocking(path, len);
        return this;
    }

    private FileSystem __chmod(String path, String perms, Handler<AsyncResult<Void>> handler) {
        this.delegate.chmod(path, perms, handler);
        return this;
    }

    public CompletionStage<Void> chmod(String path, String perms) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__chmod(path, perms, (Handler<AsyncResult<Void>>)handler));
    }

    public FileSystem chmodBlocking(String path, String perms) {
        this.delegate.chmodBlocking(path, perms);
        return this;
    }

    private FileSystem __chmodRecursive(String path, String perms, String dirPerms, Handler<AsyncResult<Void>> handler) {
        this.delegate.chmodRecursive(path, perms, dirPerms, handler);
        return this;
    }

    public CompletionStage<Void> chmodRecursive(String path, String perms, String dirPerms) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__chmodRecursive(path, perms, dirPerms, (Handler<AsyncResult<Void>>)handler));
    }

    public FileSystem chmodRecursiveBlocking(String path, String perms, String dirPerms) {
        this.delegate.chmodRecursiveBlocking(path, perms, dirPerms);
        return this;
    }

    private FileSystem __chown(String path, String user, String group, Handler<AsyncResult<Void>> handler) {
        this.delegate.chown(path, user, group, handler);
        return this;
    }

    public CompletionStage<Void> chown(String path, String user, String group) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__chown(path, user, group, (Handler<AsyncResult<Void>>)handler));
    }

    public FileSystem chownBlocking(String path, String user, String group) {
        this.delegate.chownBlocking(path, user, group);
        return this;
    }

    private FileSystem __props(String path, final Handler<AsyncResult<FileProps>> handler) {
        this.delegate.props(path, new Handler<AsyncResult<io.vertx.core.file.FileProps>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.file.FileProps> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(FileProps.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public CompletionStage<FileProps> props(String path) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__props(path, (Handler<AsyncResult<FileProps>>)handler));
    }

    public FileProps propsBlocking(String path) {
        FileProps ret = FileProps.newInstance(this.delegate.propsBlocking(path));
        return ret;
    }

    private FileSystem __lprops(String path, final Handler<AsyncResult<FileProps>> handler) {
        this.delegate.lprops(path, new Handler<AsyncResult<io.vertx.core.file.FileProps>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.file.FileProps> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(FileProps.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public CompletionStage<FileProps> lprops(String path) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__lprops(path, (Handler<AsyncResult<FileProps>>)handler));
    }

    public FileProps lpropsBlocking(String path) {
        FileProps ret = FileProps.newInstance(this.delegate.lpropsBlocking(path));
        return ret;
    }

    private FileSystem __link(String link, String existing, Handler<AsyncResult<Void>> handler) {
        this.delegate.link(link, existing, handler);
        return this;
    }

    public CompletionStage<Void> link(String link, String existing) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__link(link, existing, (Handler<AsyncResult<Void>>)handler));
    }

    public FileSystem linkBlocking(String link, String existing) {
        this.delegate.linkBlocking(link, existing);
        return this;
    }

    private FileSystem __symlink(String link, String existing, Handler<AsyncResult<Void>> handler) {
        this.delegate.symlink(link, existing, handler);
        return this;
    }

    public CompletionStage<Void> symlink(String link, String existing) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__symlink(link, existing, (Handler<AsyncResult<Void>>)handler));
    }

    public FileSystem symlinkBlocking(String link, String existing) {
        this.delegate.symlinkBlocking(link, existing);
        return this;
    }

    private FileSystem __unlink(String link, Handler<AsyncResult<Void>> handler) {
        this.delegate.unlink(link, handler);
        return this;
    }

    public CompletionStage<Void> unlink(String link) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__unlink(link, (Handler<AsyncResult<Void>>)handler));
    }

    public FileSystem unlinkBlocking(String link) {
        this.delegate.unlinkBlocking(link);
        return this;
    }

    private FileSystem __readSymlink(String link, Handler<AsyncResult<String>> handler) {
        this.delegate.readSymlink(link, handler);
        return this;
    }

    public CompletionStage<String> readSymlink(String link) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__readSymlink(link, (Handler<AsyncResult<String>>)handler));
    }

    public String readSymlinkBlocking(String link) {
        String ret = this.delegate.readSymlinkBlocking(link);
        return ret;
    }

    private FileSystem __delete(String path, Handler<AsyncResult<Void>> handler) {
        this.delegate.delete(path, handler);
        return this;
    }

    public CompletionStage<Void> delete(String path) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__delete(path, (Handler<AsyncResult<Void>>)handler));
    }

    public FileSystem deleteBlocking(String path) {
        this.delegate.deleteBlocking(path);
        return this;
    }

    private FileSystem __deleteRecursive(String path, boolean recursive, Handler<AsyncResult<Void>> handler) {
        this.delegate.deleteRecursive(path, recursive, handler);
        return this;
    }

    public CompletionStage<Void> deleteRecursive(String path, boolean recursive) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__deleteRecursive(path, recursive, (Handler<AsyncResult<Void>>)handler));
    }

    public FileSystem deleteRecursiveBlocking(String path, boolean recursive) {
        this.delegate.deleteRecursiveBlocking(path, recursive);
        return this;
    }

    private FileSystem __mkdir(String path, Handler<AsyncResult<Void>> handler) {
        this.delegate.mkdir(path, handler);
        return this;
    }

    public CompletionStage<Void> mkdir(String path) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__mkdir(path, (Handler<AsyncResult<Void>>)handler));
    }

    public FileSystem mkdirBlocking(String path) {
        this.delegate.mkdirBlocking(path);
        return this;
    }

    private FileSystem __mkdir(String path, String perms, Handler<AsyncResult<Void>> handler) {
        this.delegate.mkdir(path, perms, handler);
        return this;
    }

    public CompletionStage<Void> mkdir(String path, String perms) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__mkdir(path, perms, (Handler<AsyncResult<Void>>)handler));
    }

    public FileSystem mkdirBlocking(String path, String perms) {
        this.delegate.mkdirBlocking(path, perms);
        return this;
    }

    private FileSystem __mkdirs(String path, Handler<AsyncResult<Void>> handler) {
        this.delegate.mkdirs(path, handler);
        return this;
    }

    public CompletionStage<Void> mkdirs(String path) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__mkdirs(path, (Handler<AsyncResult<Void>>)handler));
    }

    public FileSystem mkdirsBlocking(String path) {
        this.delegate.mkdirsBlocking(path);
        return this;
    }

    private FileSystem __mkdirs(String path, String perms, Handler<AsyncResult<Void>> handler) {
        this.delegate.mkdirs(path, perms, handler);
        return this;
    }

    public CompletionStage<Void> mkdirs(String path, String perms) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__mkdirs(path, perms, (Handler<AsyncResult<Void>>)handler));
    }

    public FileSystem mkdirsBlocking(String path, String perms) {
        this.delegate.mkdirsBlocking(path, perms);
        return this;
    }

    private FileSystem __readDir(String path, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.readDir(path, handler);
        return this;
    }

    public CompletionStage<List<String>> readDir(String path) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__readDir(path, (Handler<AsyncResult<List<String>>>)handler));
    }

    public List<String> readDirBlocking(String path) {
        List<String> ret = this.delegate.readDirBlocking(path);
        return ret;
    }

    private FileSystem __readDir(String path, String filter, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.readDir(path, filter, handler);
        return this;
    }

    public CompletionStage<List<String>> readDir(String path, String filter) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__readDir(path, filter, (Handler<AsyncResult<List<String>>>)handler));
    }

    public List<String> readDirBlocking(String path, String filter) {
        List<String> ret = this.delegate.readDirBlocking(path, filter);
        return ret;
    }

    private FileSystem __readFile(String path, final Handler<AsyncResult<io.vertx.axle.core.buffer.Buffer>> handler) {
        this.delegate.readFile(path, new Handler<AsyncResult<Buffer>>(){

            @Override
            public void handle(AsyncResult<Buffer> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(io.vertx.axle.core.buffer.Buffer.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public CompletionStage<io.vertx.axle.core.buffer.Buffer> readFile(String path) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__readFile(path, (Handler<AsyncResult<io.vertx.axle.core.buffer.Buffer>>)handler));
    }

    public io.vertx.axle.core.buffer.Buffer readFileBlocking(String path) {
        io.vertx.axle.core.buffer.Buffer ret = io.vertx.axle.core.buffer.Buffer.newInstance(this.delegate.readFileBlocking(path));
        return ret;
    }

    private FileSystem __writeFile(String path, io.vertx.axle.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeFile(path, data.getDelegate(), handler);
        return this;
    }

    public CompletionStage<Void> writeFile(String path, io.vertx.axle.core.buffer.Buffer data) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__writeFile(path, data, (Handler<AsyncResult<Void>>)handler));
    }

    public FileSystem writeFileBlocking(String path, io.vertx.axle.core.buffer.Buffer data) {
        this.delegate.writeFileBlocking(path, data.getDelegate());
        return this;
    }

    private FileSystem __open(String path, OpenOptions options, final Handler<AsyncResult<AsyncFile>> handler) {
        this.delegate.open(path, options, new Handler<AsyncResult<io.vertx.core.file.AsyncFile>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.file.AsyncFile> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(AsyncFile.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public CompletionStage<AsyncFile> open(String path, OpenOptions options) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__open(path, options, (Handler<AsyncResult<AsyncFile>>)handler));
    }

    public AsyncFile openBlocking(String path, OpenOptions options) {
        AsyncFile ret = AsyncFile.newInstance(this.delegate.openBlocking(path, options));
        return ret;
    }

    private FileSystem __createFile(String path, Handler<AsyncResult<Void>> handler) {
        this.delegate.createFile(path, handler);
        return this;
    }

    public CompletionStage<Void> createFile(String path) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__createFile(path, (Handler<AsyncResult<Void>>)handler));
    }

    public FileSystem createFileBlocking(String path) {
        this.delegate.createFileBlocking(path);
        return this;
    }

    private FileSystem __createFile(String path, String perms, Handler<AsyncResult<Void>> handler) {
        this.delegate.createFile(path, perms, handler);
        return this;
    }

    public CompletionStage<Void> createFile(String path, String perms) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__createFile(path, perms, (Handler<AsyncResult<Void>>)handler));
    }

    public FileSystem createFileBlocking(String path, String perms) {
        this.delegate.createFileBlocking(path, perms);
        return this;
    }

    private FileSystem __exists(String path, Handler<AsyncResult<Boolean>> handler) {
        this.delegate.exists(path, handler);
        return this;
    }

    public CompletionStage<Boolean> exists(String path) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__exists(path, (Handler<AsyncResult<Boolean>>)handler));
    }

    public boolean existsBlocking(String path) {
        boolean ret = this.delegate.existsBlocking(path);
        return ret;
    }

    private FileSystem __fsProps(String path, final Handler<AsyncResult<FileSystemProps>> handler) {
        this.delegate.fsProps(path, new Handler<AsyncResult<io.vertx.core.file.FileSystemProps>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.file.FileSystemProps> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(FileSystemProps.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public CompletionStage<FileSystemProps> fsProps(String path) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__fsProps(path, (Handler<AsyncResult<FileSystemProps>>)handler));
    }

    public FileSystemProps fsPropsBlocking(String path) {
        FileSystemProps ret = FileSystemProps.newInstance(this.delegate.fsPropsBlocking(path));
        return ret;
    }

    private FileSystem __createTempDirectory(String prefix, Handler<AsyncResult<String>> handler) {
        this.delegate.createTempDirectory(prefix, handler);
        return this;
    }

    public CompletionStage<String> createTempDirectory(String prefix) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__createTempDirectory(prefix, (Handler<AsyncResult<String>>)handler));
    }

    public String createTempDirectoryBlocking(String prefix) {
        String ret = this.delegate.createTempDirectoryBlocking(prefix);
        return ret;
    }

    private FileSystem __createTempDirectory(String prefix, String perms, Handler<AsyncResult<String>> handler) {
        this.delegate.createTempDirectory(prefix, perms, handler);
        return this;
    }

    public CompletionStage<String> createTempDirectory(String prefix, String perms) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__createTempDirectory(prefix, perms, (Handler<AsyncResult<String>>)handler));
    }

    public String createTempDirectoryBlocking(String prefix, String perms) {
        String ret = this.delegate.createTempDirectoryBlocking(prefix, perms);
        return ret;
    }

    private FileSystem __createTempDirectory(String dir, String prefix, String perms, Handler<AsyncResult<String>> handler) {
        this.delegate.createTempDirectory(dir, prefix, perms, handler);
        return this;
    }

    public CompletionStage<String> createTempDirectory(String dir, String prefix, String perms) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__createTempDirectory(dir, prefix, perms, (Handler<AsyncResult<String>>)handler));
    }

    public String createTempDirectoryBlocking(String dir, String prefix, String perms) {
        String ret = this.delegate.createTempDirectoryBlocking(dir, prefix, perms);
        return ret;
    }

    private FileSystem __createTempFile(String prefix, String suffix, Handler<AsyncResult<String>> handler) {
        this.delegate.createTempFile(prefix, suffix, handler);
        return this;
    }

    public CompletionStage<String> createTempFile(String prefix, String suffix) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__createTempFile(prefix, suffix, (Handler<AsyncResult<String>>)handler));
    }

    public String createTempFileBlocking(String prefix, String suffix) {
        String ret = this.delegate.createTempFileBlocking(prefix, suffix);
        return ret;
    }

    private FileSystem __createTempFile(String prefix, String suffix, String perms, Handler<AsyncResult<String>> handler) {
        this.delegate.createTempFile(prefix, suffix, perms, handler);
        return this;
    }

    public CompletionStage<String> createTempFile(String prefix, String suffix, String perms) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__createTempFile(prefix, suffix, perms, (Handler<AsyncResult<String>>)handler));
    }

    public String createTempFileBlocking(String prefix, String suffix, String perms) {
        String ret = this.delegate.createTempFileBlocking(prefix, suffix, perms);
        return ret;
    }

    private FileSystem __createTempFile(String dir, String prefix, String suffix, String perms, Handler<AsyncResult<String>> handler) {
        this.delegate.createTempFile(dir, prefix, suffix, perms, handler);
        return this;
    }

    public CompletionStage<String> createTempFile(String dir, String prefix, String suffix, String perms) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__createTempFile(dir, prefix, suffix, perms, (Handler<AsyncResult<String>>)handler));
    }

    public String createTempFileBlocking(String dir, String prefix, String suffix, String perms) {
        String ret = this.delegate.createTempFileBlocking(dir, prefix, suffix, perms);
        return ret;
    }

    public static FileSystem newInstance(io.vertx.core.file.FileSystem arg) {
        return arg != null ? new FileSystem(arg) : null;
    }
}

