/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.CodeGen;
import io.vertx.codegen.GenException;
import io.vertx.codegen.Generator;
import io.vertx.codegen.GeneratorLoader;
import io.vertx.codegen.Helper;
import io.vertx.codegen.Model;
import io.vertx.codegen.generators.cheatsheet.CheatsheetGenLoader;
import io.vertx.codegen.generators.dataobjecthelper.DataObjectHelperGenLoader;
import io.vertx.codegen.generators.mvel.MvelCodeGeneratorLoader;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

@SupportedOptions(value={"codegen.output", "codegen.generators"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class CodeGenProcessor
extends AbstractProcessor {
    private static final int JAVA = 0;
    private static final int RESOURCE = 1;
    private static final int OTHER = 2;
    public static final Logger log = Logger.getLogger(CodeGenProcessor.class.getName());
    private File outputDirectory;
    private List<? extends Generator<?>> codeGenerators;
    private Map<String, GeneratedFile> generatedFiles = new HashMap<String, GeneratedFile>();
    private Map<String, GeneratedFile> generatedResources = new HashMap<String, GeneratedFile>();
    private Map<String, String> relocations = new HashMap<String, String>();
    private Set<Class<? extends Annotation>> supportedAnnotation = new HashSet<Class<? extends Annotation>>();

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return this.supportedAnnotation.stream().map(Class::getName).collect(Collectors.toSet());
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.generatedFiles.clear();
        this.generatedResources.clear();
        this.supportedAnnotation = this.getCodeGenerators().stream().flatMap(gen -> gen.annotations().stream()).collect(Collectors.toSet());
    }

    private Predicate<Generator> filterGenerators() {
        String generatorsOption = this.processingEnv.getOptions().get("codegen.generators");
        if (generatorsOption == null && (generatorsOption = this.processingEnv.getOptions().get("codeGenerators")) != null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Please use 'codegen.generators' option instead of 'codeGenerators' option");
        }
        if (generatorsOption != null) {
            List wanted = Stream.of(generatorsOption.split(",")).map(String::trim).map(Pattern::compile).collect(Collectors.toList());
            return cg -> wanted.stream().anyMatch(p -> p.matcher(cg.name).matches());
        }
        return null;
    }

    private Collection<? extends Generator<?>> getCodeGenerators() {
        if (this.codeGenerators == null) {
            String outputDirectoryOption = this.processingEnv.getOptions().get("codegen.output");
            if (outputDirectoryOption == null && (outputDirectoryOption = this.processingEnv.getOptions().get("outputDirectory")) != null) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Please use 'codegen.output' option instead of 'outputDirectory' option");
            }
            if (outputDirectoryOption != null) {
                this.outputDirectory = new File(outputDirectoryOption);
                if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Output directory " + outputDirectoryOption + " does not exist");
                }
                if (!this.outputDirectory.isDirectory()) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Output directory " + outputDirectoryOption + " is not a directory");
                }
            }
            Stream serviceLoader = StreamSupport.stream(ServiceLoader.load(GeneratorLoader.class, CodeGenProcessor.class.getClassLoader()).spliterator(), false);
            Stream loaders = Arrays.asList(new MvelCodeGeneratorLoader(), new CheatsheetGenLoader(), new DataObjectHelperGenLoader()).stream();
            Stream<Object> generators = Stream.concat(serviceLoader, loaders).flatMap(l -> l.loadGenerators(this.processingEnv));
            Predicate<Generator> filter = this.filterGenerators();
            if (filter != null) {
                generators = generators.filter(filter);
            }
            generators = generators.peek(gen -> {
                gen.load(this.processingEnv);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Loaded " + gen.name + " code generator");
            });
            this.relocations = this.processingEnv.getOptions().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("codegen.output.")).collect(Collectors.toMap(e -> ((String)e.getKey()).substring("codegen.output.".length()), Map.Entry::getValue));
            this.codeGenerators = generators.collect(Collectors.toList());
        }
        return this.codeGenerators;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            Collection<? extends Generator<?>> codeGenerators = this.getCodeGenerators();
            if (!roundEnv.errorRaised()) {
                CodeGen codegen = new CodeGen(this.processingEnv, roundEnv, this.getClass().getClassLoader());
                HashMap generatedClasses = new HashMap();
                codegen.getModels().forEach(entry -> {
                    try {
                        Model model = (Model)entry.getValue();
                        for (Generator codeGenerator : codeGenerators) {
                            List processings;
                            int kind;
                            String relativeName;
                            if (!codeGenerator.kinds.contains(model.getKind()) || (relativeName = codeGenerator.filename(model)) == null) continue;
                            if (relativeName.endsWith(".java") && !relativeName.contains("/")) {
                                String relocation = this.relocations.get(codeGenerator.name);
                                if (relocation != null) {
                                    kind = 2;
                                    relativeName = relocation + '/' + relativeName.substring(0, relativeName.length() - ".java".length()).replace('.', '/') + ".java";
                                } else {
                                    kind = 0;
                                }
                            } else {
                                kind = relativeName.startsWith("resources/") ? 1 : 2;
                            }
                            if (kind == 0) {
                                String fqn = relativeName.substring(0, relativeName.length() - ".java".length());
                                if (this.processingEnv.getElementUtils().getTypeElement(fqn) != null) continue;
                                List processings2 = generatedClasses.computeIfAbsent(fqn, GeneratedFile::new);
                                processings2.add(new ModelProcessing(model, codeGenerator));
                                continue;
                            }
                            if (kind == 1) {
                                relativeName = relativeName.substring("resources/".length());
                                processings = this.generatedResources.computeIfAbsent(relativeName, GeneratedFile::new);
                                processings.add(new ModelProcessing(model, codeGenerator));
                                continue;
                            }
                            processings = this.generatedFiles.computeIfAbsent(relativeName, GeneratedFile::new);
                            processings.add(new ModelProcessing(model, codeGenerator));
                        }
                    }
                    catch (GenException e) {
                        this.reportGenException(e);
                    }
                    catch (Exception e) {
                        this.reportException(e, (Element)entry.getKey());
                    }
                });
                generatedClasses.values().forEach(generated -> {
                    block15: {
                        boolean shouldWarningsBeSuppressed = false;
                        try {
                            String content = generated.generate();
                            if (content.length() <= 0) break block15;
                            JavaFileObject target = this.processingEnv.getFiler().createSourceFile(((GeneratedFile)generated).uri, new Element[0]);
                            try (Writer writer = target.openWriter();){
                                writer.write(content);
                            }
                            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generated model " + ((ModelProcessing)generated.get((int)0)).model.getFqn() + ": " + ((GeneratedFile)generated).uri);
                        }
                        catch (GenException e) {
                            this.reportGenException(e);
                        }
                        catch (Exception e) {
                            this.reportException(e, ((ModelProcessing)generated.get((int)0)).model.getElement());
                        }
                    }
                });
            }
        } else {
            for (GeneratedFile generated2 : this.generatedResources.values()) {
                boolean shouldWarningsBeSuppressed = false;
                try {
                    boolean createSource;
                    String content = generated2.generate();
                    if (content.length() <= 0) continue;
                    try (Writer w = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", generated2.uri, new Element[0]).openWriter();){
                        w.write(content);
                    }
                    try {
                        this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_OUTPUT, "", generated2.uri);
                        createSource = true;
                    }
                    catch (FilerException e) {
                        createSource = false;
                    }
                    if (createSource) {
                        try (Writer w = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", generated2.uri, new Element[0]).openWriter();){
                            w.write(content);
                        }
                    }
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generated model " + ((ModelProcessing)generated2.get((int)0)).model.getFqn() + ": " + generated2.uri);
                }
                catch (GenException e) {
                    this.reportGenException(e);
                }
                catch (Exception e) {
                    this.reportException(e, ((ModelProcessing)generated2.get((int)0)).model.getElement());
                }
            }
            this.generatedFiles.values().forEach(generated -> {
                Path path = new File(((GeneratedFile)generated).uri).toPath();
                if (!path.isAbsolute()) {
                    if (this.outputDirectory != null) {
                        path = this.outputDirectory.toPath().resolve(path);
                    } else {
                        return;
                    }
                }
                File file = path.toFile();
                Helper.ensureParentDir(file);
                String content = generated.generate();
                if (content.length() > 0) {
                    try (FileWriter fileWriter = new FileWriter(file);){
                        fileWriter.write(content);
                    }
                    catch (GenException e) {
                        this.reportGenException(e);
                    }
                    catch (Exception e) {
                        this.reportException(e, ((ModelProcessing)generated.get((int)0)).model.getElement());
                    }
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generated model " + ((ModelProcessing)generated.get((int)0)).model.getFqn() + ": " + ((GeneratedFile)generated).uri);
                }
            });
        }
        return true;
    }

    private void reportGenException(GenException e) {
        String name = e.element.toString();
        if (e.element.getKind() == ElementKind.METHOD) {
            name = e.element.getEnclosingElement() + "#" + name;
        }
        String msg = "Could not generate model for " + name + ": " + e.msg;
        log.log(Level.SEVERE, msg, e);
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e.element);
    }

    private void reportException(Exception e, Element elt) {
        String msg = "Could not generate element for " + elt + ": " + e.getMessage();
        log.log(Level.SEVERE, msg, e);
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, elt);
    }

    private static class GeneratedFile
    extends ArrayList<ModelProcessing> {
        private final String uri;
        private final Map<String, Object> session = new HashMap<String, Object>();

        public GeneratedFile(String uri) {
            this.uri = uri;
        }

        @Override
        public boolean add(ModelProcessing modelProcessing) {
            if (!modelProcessing.generator.incremental) {
                this.clear();
            }
            return super.add(modelProcessing);
        }

        String generate() {
            Collections.sort(this, (o1, o2) -> o1.model.getElement().getSimpleName().toString().compareTo(o2.model.getElement().getSimpleName().toString()));
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < this.size(); ++i) {
                ModelProcessing processing = (ModelProcessing)this.get(i);
                try {
                    String part = processing.generator.render(processing.model, i, this.size(), this.session);
                    if (part == null) continue;
                    buffer.append(part);
                    continue;
                }
                catch (GenException e) {
                    throw e;
                }
                catch (Exception e) {
                    GenException genException = new GenException(processing.model.getElement(), e.getMessage());
                    genException.initCause(e);
                    throw genException;
                }
            }
            return buffer.toString();
        }
    }

    private static class ModelProcessing {
        final Model model;
        final Generator generator;

        public ModelProcessing(Model model, Generator generator) {
            this.model = model;
            this.generator = generator;
        }
    }
}

