/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.rbac.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2RBAC;
import java.util.Collections;

public class KeycloakRBACImpl
implements OAuth2RBAC {
    private static final JsonObject EMPTY_JSON = new JsonObject(Collections.EMPTY_MAP);
    private static final JsonArray EMPTY_ARRAY = new JsonArray(Collections.EMPTY_LIST);
    private final OAuth2ClientOptions options;

    public KeycloakRBACImpl(OAuth2ClientOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("options is a required argument");
        }
        this.options = options;
    }

    @Override
    public void isAuthorized(AccessToken user, String authority, Handler<AsyncResult<Boolean>> handler) {
        JsonObject accessToken = user.accessToken();
        if (accessToken == null) {
            handler.handle(Future.failedFuture("AccessToken is not a valid JWT"));
            return;
        }
        String[] parts = authority.split(":");
        if (parts.length == 1) {
            handler.handle(Future.succeededFuture(this.hasApplicationRole(accessToken, this.options.getClientID(), parts[0])));
            return;
        }
        if ("realm".equals(parts[0])) {
            handler.handle(Future.succeededFuture(this.hasRealmRole(accessToken, parts[1])));
            return;
        }
        handler.handle(Future.succeededFuture(this.hasApplicationRole(accessToken, parts[0], parts[1])));
    }

    private boolean hasApplicationRole(JsonObject accessToken, String appName, String roleName) {
        if (accessToken == null) {
            return false;
        }
        JsonObject appRoles = accessToken.getJsonObject("resource_access", EMPTY_JSON).getJsonObject(appName);
        if (appRoles == null) {
            return false;
        }
        return appRoles.getJsonArray("roles", EMPTY_ARRAY).contains(roleName);
    }

    private boolean hasRealmRole(JsonObject accessToken, String roleName) {
        if (accessToken == null) {
            return false;
        }
        return accessToken.getJsonObject("realm_access", EMPTY_JSON).getJsonArray("roles", EMPTY_ARRAY).contains(roleName);
    }
}

